package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.SceneTestcaseReport;
import cn.qg.holmes.entity.auto.TestcaseReport;
import cn.qg.holmes.service.auto.SceneTestcaseReportService;
import cn.qg.holmes.service.auto.TestcaseReportService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 测试报告相关接口
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/report")
public class TestReportController {

    @Autowired
    TestcaseReportService testcaseReportService;

    @Autowired
    SceneTestcaseReportService sceneTestcaseReportService;

    /**
     * 根据namespace和模块id获取单接口用例batch列表
     * @param namespace 环境
     * @param moduleId 模块id
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/testcase/batch/list")
    public JsonResult getTestcaseReportBatchList(String namespace, Integer moduleId, Integer pageNum, Integer pageSize) {
        IPage<Map<String, Object>> mapIPage = testcaseReportService.getTestcaseReportGroupByBatch(namespace, moduleId, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("total", mapIPage.getTotal());
        map.put("list", mapIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 根据环境和项目id获取场景batch列表
     * @param namespace 环境
     * @param projectId 项目id
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/scene/batch/list")
    public JsonResult getSceneTestcaseReportBatchList(String namespace, Integer projectId, Integer sceneId, String sceneName, @RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        IPage<Map<String, Object>> sceneTestcaseReportIPage = sceneTestcaseReportService.getSceneTestcaseReportGroupByBatch(namespace, projectId, sceneId, sceneName, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("total", sceneTestcaseReportIPage.getTotal());
        map.put("list", sceneTestcaseReportIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    @GetMapping("/testcase/list")
    public JsonResult getTestcaseReportListByNamespace(String namespace,
                                                       Integer projectId,
                                                       @RequestParam(defaultValue = "1") Integer pageNum,
                                                       @RequestParam(defaultValue = "10") Integer pageSize) {
        return JsonResult.buildSuccessResult(testcaseReportService.getTestcaseReportByNamespace(namespace, projectId, pageNum, pageSize));
    }

    @GetMapping("/scene/list")
    public JsonResult getSceneTestcaseReportListByNamespace(String namespace,
                                                            Integer moduleId,
                                                            @RequestParam(defaultValue = "1") Integer pageNum,
                                                            @RequestParam(defaultValue = "10") Integer pageSize) {
        return JsonResult.buildSuccessResult(sceneTestcaseReportService.getSceneTestcaseReportListByNamespace(namespace, moduleId, pageNum, pageSize));
    }

    /**
     * 获取testcase batch详情列表
     * @param namespace 环境
     * @param batch batch名
     * @return
     */
    @GetMapping("/testcase/batch/detail")
    public JsonResult getTestcaseReportBatchDetail(String namespace, String batch) {
        if (batch == null || batch.isEmpty()) {
             return JsonResult.buildErrorStateResult("batch不能为空！", false);
        }
        if (namespace == null || namespace.isEmpty()) {
            return JsonResult.buildErrorStateResult("namespace不能为空！", false);
        }
        QueryWrapper<TestcaseReport> testcaseReportQueryWrapper = new QueryWrapper<>();
        testcaseReportQueryWrapper.eq("namespace", namespace);
        testcaseReportQueryWrapper.eq("batch", batch);
        List<TestcaseReport> testcaseReports = testcaseReportService.list(testcaseReportQueryWrapper);
        return JsonResult.buildSuccessResult(testcaseReports);
    }

    /**
     * 获取场景batch详情列表
     * @param namespace 环境
     * @param batch batch名
     * @return
     */
    @GetMapping("/scene/batch/detail")
    public JsonResult getSceneReportBatchDetail(String namespace, String batch) {
        if (batch == null || batch.isEmpty()) {
            return JsonResult.buildErrorStateResult("batch不能为空！", false);
        }
        if (namespace == null || namespace.isEmpty()) {
            return JsonResult.buildErrorStateResult("namespace不能为空！", false);
        }
        QueryWrapper<SceneTestcaseReport> sceneTestcaseReportQueryWrapper = new QueryWrapper<>();
        sceneTestcaseReportQueryWrapper.eq("namespace", namespace);
        sceneTestcaseReportQueryWrapper.eq("batch", batch);
        List<SceneTestcaseReport> sceneTestcaseReports = sceneTestcaseReportService.list(sceneTestcaseReportQueryWrapper);
        return JsonResult.buildSuccessResult(sceneTestcaseReports);
    }
}
