package cn.qg.holmes.encrypt;

import cn.qg.holmes.encrypt.xincheng.Base64;
import cn.qg.holmes.encrypt.xincheng.RSA;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Component
public class XinchengEncryptConvertor implements EncryptConvertor {

    @Value("${xincheng.fund.public.key}")
    private String xinchengPublicKey;

    @Value("${xincheng.lhp.private.key}")
    private String lhpPrivateKey;


    @Override
    public String encrypt(String response) {
        String encodeData;
        try {
            encodeData = new String(Base64.encodeBase64(RSA.encryptByPrivateKey(response.getBytes(), lhpPrivateKey)), Charsets.UTF_8);
        } catch (Exception e) {
            log.error("encrypt,encrypt request is error ", e);
            throw new RuntimeException("加密失败！");
        }
        Map<String, String> map = new HashMap<>();
        map.put("appId", "1050");
        map.put("content", encodeData);
        return JSON.toJSONString(map);
    }

    @Override
    public String decrypt(String request) {
        String decodeData;
//        Map<String, Object> requestMap = JSON.parseObject(request, Map.class);
//        String requestStr = JSON.toJSONString(requestMap.get("content"));
        try {
            decodeData = new String(RSA.decryptByPublicKey(Base64.decodeBase64(request.getBytes()), xinchengPublicKey), Charsets.UTF_8);
            log.info("新增解密后的响应结果为：{}", decodeData);
        } catch (Exception e) {
            log.error("decrypt, decrypt response is error ", e);
            throw new RuntimeException("解密新橙响应结果失败！");
        }
        return decodeData;
    }
}
