package cn.qg.holmes.service.k8s.impl;

import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.mapper.k8s.DockerProjectMapper;
import cn.qg.holmes.service.k8s.DockerProjectService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DockerProjectServiceImpl extends ServiceImpl<DockerProjectMapper, DockerProject> implements DockerProjectService {

    @Autowired
    DockerProjectMapper dockerProjectMapper;

    /**
     * 条件分页查询
     * @param projectName 项目名称
     * @param projectType 项目类型，Java UI、node等等
     * @param isActive 是否可用
     * @param pageNum 第几页
     * @param pageSize 每页展示多少个
     * @return
     */
    @Override
    public IPage<DockerProject> getDockerProjectList(String projectName, String projectType, Integer isActive, Integer pageNum, Integer pageSize) {
        IPage<DockerProject> page = new Page<>(pageNum, pageSize);
        return dockerProjectMapper.getDockerProjectList(page, projectName, projectType, isActive);
    }
}
