package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.Permission;
import cn.qg.holmes.mapper.auth.PermissionMapper;
import cn.qg.holmes.service.auth.PermissionService;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class PermissionServiceImpl extends ServiceImpl<PermissionMapper, Permission> implements PermissionService {

    @Autowired
    PermissionMapper permissionMapper;

    @Override
    public List<Map<String, Object>> getPermissionList() {
        List<Map<String, Object>> result = new ArrayList<>();
        QueryWrapper<Permission> permissionQueryWrapper = new QueryWrapper<>();
        permissionQueryWrapper.select("DISTINCT menu_name");
        List<Permission> permissionList = permissionMapper.selectList(permissionQueryWrapper);
        List<String> menuNameList = new ArrayList<>();
        permissionList.forEach(permission -> {
            menuNameList.add(permission.getMenuName());
        });
        permissionQueryWrapper.clear();
        for (String menuName: menuNameList) {
            permissionQueryWrapper.eq("menu_name", menuName);
            List<Permission> permissions = permissionMapper.selectList(permissionQueryWrapper);
            Map<String, Object> map = new HashMap<>();
            List<Map<String, Object>> tempPermissionList = new ArrayList<>();
            permissions.forEach(permission -> {
                Map<String, Object> map2 = new HashMap<>();
                map2.put("id", permission.getId());
                map2.put("permissionName", permission.getPermissionName());
                tempPermissionList.add(map2);
            });
            map.put("menuName", menuName);
            map.put("permissionList", tempPermissionList);
            result.add(map);
            permissionQueryWrapper.clear();
        }
        return result;
    }
}
