package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.entity.k8s.ServiceCreateVo;
import cn.qg.holmes.service.k8s.DockerProjectService;
import cn.qg.holmes.service.k8s.ImageService;
import cn.qg.holmes.service.k8s.TkeService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * k8及容器操作相关接口
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/k8s")
public class K8sController {

    @Autowired
    TkeService tkeService;

    @Autowired
    ImageService imageService;

    @Autowired
    DockerProjectService dockerProjectService;

    /**
     * 获取namespace列表
     * @return
     */
    @GetMapping("/namespace")
    public JsonResult getNamespaceList() {
        return JsonResult.buildSuccessResult(tkeService.getNamespaceList());
    }

    /**
     * 获取pod列表
     * @param namespace 环境
     * @return
     */
    @GetMapping("/pod/list")
    public JsonResult getServiceList(@RequestParam String namespace) {
        List<Map<String, Object>> podList = tkeService.getPodList(namespace);
        return JsonResult.buildSuccessResult(podList);
    }

    /**
     * 根据服务名称获取镜像列表
     * @param serviceName 服务名称
     * @return
     */
    @GetMapping("/image/list")
    public JsonResult getImageListByServiceName(@RequestParam String serviceName) {
        return JsonResult.buildSuccessResult(imageService.getImageListByService(serviceName));
    }

    /**
     * 新增pod
     * @param serviceCreateVo 创建实体类
     * @return
     */
    @PostMapping("/pod/create")
    public JsonResult createPod(@RequestBody ServiceCreateVo serviceCreateVo) {
        try {
            String serviceName = serviceCreateVo.getServiceName();
            QueryWrapper<DockerProject> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_name", serviceName);
            DockerProject dockerProject = dockerProjectService.getOne(queryWrapper);
            tkeService.createJavaDeployment(serviceCreateVo, dockerProject);
            return JsonResult.buildSuccessResult("pod创建成功！");
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("pod创建失败！", false);
        }
    }

    /**
     * 重置pod
     * @param namespace 环境
     * @param podName podName
     * @return
     */
    @PostMapping("/pod/redeploy")
    public JsonResult resetPodByName(String namespace, String podName) {
        return JsonResult.buildSuccessResult(tkeService.resetPod(namespace, podName));
    }

    /**
     * 删除pod
     * @param namespace 环境
     * @param serviceName 服务名称
     * @return
     */
    @PostMapping("/pod/delete")
    public JsonResult deletePodByName(String namespace, String serviceName) {
        return JsonResult.buildSuccessResult(tkeService.deleteService(namespace, serviceName));
    }
}
