package cn.qg.holmes.service.k8s;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.tcr.v20190924.TcrClient;
import com.tencentcloudapi.tcr.v20190924.models.DescribeImagePersonalRequest;
import com.tencentcloudapi.tcr.v20190924.models.DescribeImagePersonalResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 镜像仓库相关服务
 * @author libo 2021
 */
@Slf4j
@Component
public class ImageService {

    private TcrClient tcrClient;

    public ImageService() {
        try {
            Credential credential = new Credential("AKID4rY7wwNphsUcaFsy1pRtKhQvDj4CA3Ac", "YBduRnjgVRGzmagZJbss3Vo58wWCyhgc");

            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");

            tcrClient = new TcrClient(credential, "ap-beijing", clientProfile);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据服务名获取镜像列表
     * @param serviceName 服务名
     * @return
     */
    public String getImageListByService(String serviceName) {
        try {
            String repoName = "qa-test/" + serviceName;
            DescribeImagePersonalRequest request = new DescribeImagePersonalRequest();
            request.setRepoName(repoName);
            DescribeImagePersonalResponse response = tcrClient.DescribeImagePersonal(request);
            return DescribeImagePersonalResponse.toJsonString(response);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ImageService imageService = new ImageService();
        System.out.println(imageService.getImageListByService("kdsp"));
    }

}
