package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.entity.auth.UserInfoVo;
import cn.qg.holmes.service.auth.LoginService;
import cn.qg.holmes.service.auth.TokenService;
import cn.qg.holmes.service.auth.UserRoleService;
import cn.qg.holmes.service.auth.UserService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RequestMapping("/user")
@RestController
public class UserController {

    @Autowired
    UserService userService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    LoginService loginService;

    @Autowired
    TokenService tokenService;

    /**
     * 登录，鉴权走ldap
     * @param username 用户名
     * @param password 密码
     * @return
     */
    @PostMapping("/login")
    public JsonResult login(String username, String password) {
        boolean loginResult = loginService.login(username, password);
        if (!loginResult) {
            return JsonResult.buildErrorStateResult("用户名或密码错误", false);
        }
        User user = userService.getUserByUsername(username);
        // 用户不存在，则创建新用户
        if (user == null) {
            User newUser = new User();
            newUser.setUsername(username);
            newUser.setPassword(DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8)));
            userService.save(newUser);
        }
        user = userService.getUserByUsername(username);
        String token = tokenService.generateToken(user.getId());
        Map<String, Object> map = new HashMap<>();
        map.put("token", token);
//        map.put("data", userService.getUserInfoByUsername(username));
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 登出
     * @param token token
     * @return
     */
    @PostMapping("/logout")
    public JsonResult logout(@RequestHeader String token) {
        tokenService.invalidateToken(token);
        return JsonResult.buildSuccessResult("登出成功！", true);
    }

    /**
     * 获取用户信息
     * @return
     */
    @GetMapping("/info")
    public JsonResult getInfo(@RequestHeader String token) {
        UserInfoVo userInfoVo = tokenService.getUserInfoFromCache(token);
        return JsonResult.buildSuccessResult(userInfoVo);
    }

    /**
     * 获取用户信息列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getUserList(@RequestParam(defaultValue = "1") Integer pageNum,
                                  @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<User> userIPage = userService.getUserInfoList(pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("total", userIPage.getTotal());
        map.put("list", userIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }
}
