package cn.qg.holmes.service.jira;

import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Issue;
import org.joda.time.DateTime;

public interface JiraIssueService {

    Iterable<Issue> getUnsolvedIssueListByProject(String project) throws Exception;

    Iterable<Issue> getIssueListByJQL(String JQL) throws Exception;

    Iterable<BasicProject> getJiraProjectList() throws Exception;

    Integer calculateBugFixTime(DateTime startDate, DateTime endDate);

    Issue getJiraIssueByKey(String key) throws Exception;

}
