package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.service.auth.LdapService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import java.util.Hashtable;

@Slf4j
@Service
public class LdapServiceImpl implements LdapService, CommandLineRunner {
    private LdapContext ctx = null;
    private final Control[] connCtls = null;

    private final String BASEDN = "ou=北京量科邦信息技术有限公司,dc=quantgroup,dc=cn";
    private final String URL = "ldap://ldap.quantgroups.com:389/";
    private final String password = "Quantgroup.com@2o17";
    private final String username = "cn=common_auth_query,cn=users,DC=quantgroup,DC=cn";

    private void ldapConnect() {
        Hashtable<String, String> env = new Hashtable<>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(Context.PROVIDER_URL, URL + BASEDN);
        env.put(Context.SECURITY_AUTHENTICATION, "simple");

        env.put(Context.SECURITY_PRINCIPAL, username);
        env.put(Context.SECURITY_CREDENTIALS, password);
        // 此处若不指定用户名和密码,则自动转换为匿名登录
        try {
            ctx = new InitialLdapContext(env, connCtls);
        } catch (Exception e) {
            log.error("初始化失败：{}", ExceptionUtils.getStackTrace(e));
        }
    }

    private String getUserDN(String username) {
        String userDN = "";
        ldapConnect();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
            String email = username.endsWith("@quantgroup.cn") ? username : username + "@quantgroup.cn";
            NamingEnumeration<SearchResult> en = ctx.search("", "mail=" + email, constraints);
            if (en == null || !en.hasMoreElements()) {
                log.info("未找到该用户,uid={}", username);
            }
            // maybe more than one element
            while (en != null && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof SearchResult) {
                    SearchResult si = (SearchResult) obj;
                    userDN += si.getName();
                    userDN += "," + BASEDN;
                } else {
                    System.out.println(obj);
                }
            }
        } catch (Exception e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            e.printStackTrace();
        }
        return userDN;
    }

    @Override
    public boolean authenticate(String username, String password) {
        boolean validate;
        String userDN = getUserDN(username);
        try {
            ctx.addToEnvironment(Context.SECURITY_PRINCIPAL, userDN);
            ctx.addToEnvironment(Context.SECURITY_CREDENTIALS, password);
            ctx.reconnect(connCtls);
            log.info("验证通过,uid={}", username);
            validate = true;
        } catch (AuthenticationException e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            System.out.println(e.toString());
            validate = false;
        } catch (NamingException e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            validate = false;
        }
        return validate;
    }

    @Override
    public void run(String... args) throws Exception {
        ldapConnect();
    }
}
