package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Role;
import cn.qg.holmes.service.auth.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("/role")
public class RoleController {

    @Autowired
    RoleService roleService;

    @PostMapping("/add")
    public JsonResult addRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.save(role));
    }

    @PostMapping("/edit")
    public JsonResult editRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.saveOrUpdate(role));
    }

    @PostMapping("/delete")
    public JsonResult delRole(Integer roleId) {
        return JsonResult.buildSuccessResult(roleService.removeById(roleId));
    }
}
