package cn.qg.holmes.controller.mock.keystone;

import cn.qg.holmes.bean.KeystoneService;
import cn.qg.holmes.entity.mock.keystone.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
public class OrderController {

    @Autowired
    KeystoneService keystoneService;

    /**
     * 商品税率
     */
    private final BigDecimal TAX = new BigDecimal("0.13");

    /**
     * SKU分配，随便MOCK一个
     */
    private final Integer SKU_CATEGORY = 15924;

    /**
     * 7.3 企业购提交订单
     * @param submitOrderRequest 请求参数
     * @return
     */
    @PostMapping("/api/order/submitOrder")
    public JSONObject qygSubmitOrder(SubmitOrderRequest submitOrderRequest) {
        log.info("收到企业购提交订单请求：{}", JSON.toJSONString(submitOrderRequest));
        JSONObject response = new JSONObject();
        JSONArray orderPriceSnapArray = JSON.parseArray(submitOrderRequest.getOrderPriceSnap());
        JSONArray skuInfoArray = JSON.parseArray(submitOrderRequest.getSku());
        List<SubmitOrderRequest.JdSkuPriceInfo> orderPriceSnaps = JSON.parseObject(orderPriceSnapArray.toJSONString(), new TypeReference<List<SubmitOrderRequest.JdSkuPriceInfo>>() {});
        List<SubmitOrderRequest.JdSkuInfo> skuInfos = JSON.parseObject(skuInfoArray.toJSONString(), new TypeReference<List<SubmitOrderRequest.JdSkuInfo>>() {});
        Map<String, BigDecimal> skuPriceMap = convertSkuPriceMap(orderPriceSnaps);
        // 计算订单总金额
        BigDecimal orderPrice = new BigDecimal(0);
        for (SubmitOrderRequest.JdSkuInfo jdSkuInfo: skuInfos) {
            BigDecimal skuNum = new BigDecimal(jdSkuInfo.getNum());
            String skuId = jdSkuInfo.getSkuId();
            BigDecimal price = skuPriceMap.get(skuId);
            orderPrice = orderPrice.add(price.multiply(skuNum));
        }
        response.put("success", true);
        response.put("resultCode", "0001");
        response.put("resultMessage", "下单成功");
        JSONObject result = new JSONObject();
        result.put("jdOrderId", RandomStringUtils.randomNumeric(12));
        result.put("freight", calculateFreight(orderPrice));
        result.put("orderPrice", orderPrice);
        BigDecimal orderNakedPrice = orderPrice.divide(TAX.add(new BigDecimal(1)), BigDecimal.ROUND_HALF_UP);
        result.put("orderNakedPrice", orderNakedPrice);
        List<BizSku> bizSkuList = new ArrayList<>();
        for (SubmitOrderRequest.JdSkuInfo sku: skuInfos) {
            BizSku bizSku = new BizSku();
            String skuId = sku.getSkuId();
            ProductItem productItem = keystoneService.getProductItemById(skuId);
            bizSku.setSkuId(Long.valueOf(skuId));
            bizSku.setNum(sku.getNum());
            bizSku.setCategory(SKU_CATEGORY);
            BigDecimal price = skuPriceMap.get(skuId);
            bizSku.setPrice(price);
            bizSku.setName(productItem.getName());
            bizSku.setTax(TAX.multiply(new BigDecimal(102)));
            BigDecimal nakedPrice = price.divide(TAX.add(new BigDecimal(1)), BigDecimal.ROUND_HALF_UP);
            bizSku.setNakedPrice(nakedPrice);
            bizSku.setTaxPrice(price.subtract(nakedPrice));
            bizSku.setType(0);
            bizSku.setOid(0L);

            bizSkuList.add(bizSku);
        }
        result.put("sku", bizSkuList);
        result.put("orderTaxPrice", orderNakedPrice.multiply(TAX).setScale(2, BigDecimal.ROUND_HALF_UP));
        response.put("result", result);
        return response;
    }

    /**
     * 7.5 确认预占库存订单
     * @return
     */
    @PostMapping("/api/order/confirmOrder")
    public JSONObject qygConfirmOrder(JdConfirmOrderRequest request) {
        JSONObject response = new JSONObject();
        response.put("success", true);
        response.put("resultMessage", "确认下单成功");
        response.put("resultCode", "0003");
        response.put("result", true);
        return response;
    }

    /**
     * 7.6 取消未确认订单
     */
    @PostMapping("/api/order/cancel")
    public JSONObject qygOrderCancel(JdCancelOrderRequest request) {
        JSONObject resposne = new JSONObject();
        resposne.put("success", true);
        resposne.put("resultMessage", "取消订单成功");
        resposne.put("resultCode", "0002");
        resposne.put("result", true);
        return resposne;
    }

    /**
     * 11.1 查询推送消息
     * @return
     */
    @PostMapping("/api/message/get")
    public JSONObject qygMessageGet(JdCompanyMsgRequest request) {
        String type = request.getType();
        JSONObject response = new JSONObject();
        response.put("success", true);
        response.put("resultMessage", "");
        response.put("resultCode", "0000");
        JSONArray result = new JSONArray();
        switch (type) {
            case "10":
                // TODO
                break;
            case "31":
                // TODO
                break;
            default:
                break;
        }
        response.put("result", result);
        return response;
    }


    /**
     * 列表转Map，key为skuId，value是price
     * @param orderPriceSnaps JdSkuPriceInfo列表
     * @return
     */
    public Map<String, BigDecimal> convertSkuPriceMap(List<SubmitOrderRequest.JdSkuPriceInfo> orderPriceSnaps) {
        Map<String, BigDecimal> map = new HashMap<>();
        for (SubmitOrderRequest.JdSkuPriceInfo jdSkuPriceInfo: orderPriceSnaps) {
            map.put(jdSkuPriceInfo.getSkuId(), jdSkuPriceInfo.getPrice());
        }
        return map;
    }

    /**
     * 计算运费
     * @param totalPrice 总价格
     * @return
     */
    public BigDecimal calculateFreight(BigDecimal totalPrice) {
        if (totalPrice.compareTo(new BigDecimal("99")) >= 0) {
            return new BigDecimal("0");
        } else {
            return new BigDecimal("6");
        }
    }
}
