package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class DingdingUtils {

    public static boolean sendToDingding(String jsonString, String webhook) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String result = HttpClientUtils.doPostJson(webhook, headers, jsonString);
        log.info("发送给钉钉: {}, 内容：{}, 钉钉返回结果：{}", webhook, jsonString, result);
        Map<String, String> resultMap = JSON.parseObject(result, Map.class);
        return resultMap.get("errmsg").equals("ok");
    }

    public static String buildMarkdownMsg(String key, String summary, String creator, String assignee, String priority, String module) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> content = new HashMap<>();
        markdown.put("msgtype", "markdown");
        String title = creator + "提交了BUG：" + key;
        String issueUrl = "http://jira2.quantgroup.cn/browse/" + key;
        content.put("title", title);
        content.put("text", "### " + title + "\n"
                + "#### 概要：[" + summary + "](" + issueUrl + ")"+ "\n"
                + "- 优先级：" + priority + "\n"
                + "- 模块：" + module + "\n"
                + "- 经办人：" + assignee);
        markdown.put("markdown", content);
        return JSON.toJSONString(markdown);
    }

    public static void main(String[] args) {
        String markdown = buildMarkdownMsg("YXM-1499", "【羊小咩v7.6.00】【VCC首次交易率提升专题】巴拉巴拉", "黎博", "于巧玲", "p1", "kddsp");
        sendToDingding(markdown, "https://oapi.dingtalk.com/robot/send?access_token=835663338d638e40daaf3ab358af741ef0680a826a962c91bedc53b149d85ee1");
    }
}
