package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class JdSubmitOrderResponse extends JdBaseResponse {

    private JdSumbitOrderInfo result;

    @Data
    public static class JdSumbitOrderInfo{

        /**
         * 京东订单号
         */
        private Long jdOrderId;

        /**
         * 运费
         */
        private BigDecimal freight;

        /**
         * 订单总金额
         */
        private BigDecimal orderPrice;

        /**
         * 订单未税金额
         */
        private BigDecimal orderNakedPrice;

        /**
         * 订单税额
         */
        private BigDecimal orderTaxPrice;

        /**
         * 订单包含的商品信息列表
         */
        private List<JdBizSku> sku;
    }

    @Data
    public static class JdBizSku{

        /**
         * 京东商品编号
         */
        private Long skuId;

        /**
         * 购买商品数量
         */
        private Integer num;

        /**
         * 商品分类编号
         */
        private Integer category;

        /**
         * 商品单价
         */
        private BigDecimal price;

        /**
         * 商品名称
         */
        private String name;

        /**
         * 商品税率
         */
        private BigDecimal tax;

        /**
         * 商品税额
         */
        private BigDecimal taxPrice;

        /**
         * 商品未税价
         */
        private BigDecimal nakedPrice;

        /**
         * 商品类型：0普通、1附件、2赠品
         */
        private Integer type;

        /**
         * 主商品skuid，如果本身是主商品，则oid为0
         */
        private Long oid;
    }
}
