package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabProject;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class GitlabService {

    private static final String URL = "http://git.quantgroup.cn/";
    private static final String TOKEN = "owKJZwenxNaypTAz4Zcd";
    private static final String TJZIMU_URL = "https://gitlab.tjzimu.com/";
    private static final String TJZIMU_TOKEN = "jDqS5EHHzpGsn8J1aCUG";
    private GitlabAPI gitlabAPI;
    private GitlabAPI tjzimuGitlabAPI;

    public GitlabService() {
        try {
            gitlabAPI = GitlabAPI.connect(URL, TOKEN);
            tjzimuGitlabAPI = GitlabAPI.connect(TJZIMU_URL, TJZIMU_TOKEN);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取所有的项目
     * @return
     */
    public List<Map<String, Object>> getProjectList() {
        List<GitlabProject> gitlabProjectList = gitlabAPI.getProjects();
        List<Map<String, Object>> projectMapList = new ArrayList<>();
        for (GitlabProject gitlabProject: gitlabProjectList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", gitlabProject.getId());
            map.put("name", gitlabProject.getName());
            projectMapList.add(map);
        }
        return projectMapList;
    }

    public List<String> getBranchesByProjectName(String projectName) {
        List<Map<String, Object>> projectList = getProjectList();
        Integer projectId = null;
        for (Map<String, Object> map: projectList) {
            if (map.get("name").toString().equals(projectName)) {
                projectId = (Integer) map.get("id");
            }
        }
        List<GitlabBranch> gitlabBranchList = gitlabAPI.getBranches(projectId);
        List<String> branches = new ArrayList<>();
        for (GitlabBranch gitlabBranch: gitlabBranchList) {
            branches.add(gitlabBranch.getName());
        }
        return branches;
    }

    public List<Map<String, Object>> getProjectByRestApi(String projectName) {
        String url = URL + "api/v4/projects";
        String tjzimuUrl = TJZIMU_URL + "api/v4/projects";
        Map<String, String> params = new HashMap<>();
        String result;
        params.put("per_page", "200");
        params.put("search", projectName);
        params.put("simple", "true");
        if (projectName.equals("xyqb-user3")) {
            params.put("private_token", TJZIMU_TOKEN);
            result = HttpClientUtils.doGet(tjzimuUrl, params);
        } else {
            params.put("private_token", TOKEN);
            result = HttpClientUtils.doGet(url, params);
        }
        return (List<Map<String, Object>>) JSON.parse(result);
    }

    public List<Map> getBranchesByProjectId(String projectName, Integer projectId) {
        String url = URL + "api/v4/projects/" + projectId.toString() + "/repository/branches";
        String tjzimuUrl = TJZIMU_URL + "api/v4/projects/" + projectId.toString() + "/repository/branches";
        Map<String, String> params = new HashMap<>();
        List<Map> branchList = new ArrayList<>();
        params.put("per_page", "100");
        if (projectName.equals("xyqb-user3")) {
            params.put("private_token", TJZIMU_TOKEN);
        } else {
            params.put("private_token", TOKEN);
        }
        for (int i=0; i < 4; i++) {
            params.put("page", String.valueOf(i+1));
            String requestResult;
            if (projectName.equals("xyqb-user3")) {
                requestResult = HttpClientUtils.doGet(tjzimuUrl, params);
            } else {
                requestResult = HttpClientUtils.doGet(url, params);
            }
            branchList.addAll(JSONArray.parseArray(requestResult, Map.class));
        }
        return branchList;
    }


    public static void main(String[] args) {
        GitlabService gitlabService = new GitlabService();
//        List<String> branches = gitlabService.getBranchesByProjectName("holmes");
//        System.out.println(branches);
//        System.out.println(gitlabService.getProjectByRestApi("holmes"));
//        System.out.println(gitlabService.getBranchesByProjectId("holmes", 795).size());
        System.out.println(gitlabService.getProjectByRestApi("xyqb-user3"));
    }

}
