package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.EnvTemplate;
import cn.qg.holmes.service.k8s.EnvTemplateService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/env/template")
public class EnvTemplateController {

    @Autowired
    EnvTemplateService envTemplateService;

    /**
     * 获取所有的模板
     * @return
     */
    @GetMapping("/getAll")
    public JsonResult getTemplateByName() {

        QueryWrapper<EnvTemplate> queryWrapper = new QueryWrapper<>();
        queryWrapper.groupBy("template_name");
        List<EnvTemplate> envTemplateList = envTemplateService.list(queryWrapper);
        queryWrapper.clear();

        List<Map<String, Object>> resultList = new ArrayList<>();
        for (EnvTemplate envTemplate: envTemplateList) {
            String templateName = envTemplate.getTemplateName();
            queryWrapper.eq("template_name", templateName);
            List<EnvTemplate> etList = envTemplateService.list(queryWrapper);
            // 创建一个Map用来存储
            Map<String, Object> map = new HashMap<>();
            map.put("name", templateName);
            for (EnvTemplate et: etList) {
                if (!map.containsKey(et.getLabel())) {
                    List<EnvTemplate> mapList = new ArrayList<>();
                    mapList.add(et);
                    map.put(et.getLabel(), mapList);
                } else {
                    List<EnvTemplate> temp = (List<EnvTemplate>) map.get(et.getLabel());
                    temp.add(et);
                    map.put(et.getLabel(), temp);
                    temp = null;
                }
            }
            resultList.add(map);
            queryWrapper.clear();
        }
        return JsonResult.buildSuccessResult(resultList);
    }

    /**
     * 新建模板
     * @param envTemplateList 模板列表
     * @return
     */
    @PostMapping("/create")
    public JsonResult saveEnvTemplate(@RequestBody List<EnvTemplate> envTemplateList) {
        if (envTemplateList.size() == 0) {
            return JsonResult.buildErrorStateResult("参数不能为空!", false);
        }
        return JsonResult.buildSuccessResult(envTemplateService.saveBatch(envTemplateList));
    }

    /**
     * 编辑模板
     * @param envTemplateList 模板列表
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifyEnvTemplate(@RequestBody List<EnvTemplate> envTemplateList) {
        return JsonResult.buildSuccessResult(envTemplateService.updateBatchById(envTemplateList));
    }

    @PostMapping("/delete")
    public JsonResult deleteEnvTemplate(@RequestParam String templateName) {
        QueryWrapper<EnvTemplate> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("template_name", templateName);
        List<EnvTemplate> envTemplateList = envTemplateService.list(queryWrapper);
        List<Integer> templateIdList = new ArrayList<>();
        envTemplateList.forEach(envTemplate -> templateIdList.add(envTemplate.getId()));
        return JsonResult.buildSuccessResult(envTemplateService.removeByIds(templateIdList));
    }
}
