package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.EnvTemplate;
import cn.qg.holmes.entity.k8s.EnvTemplateDetail;
import cn.qg.holmes.entity.k8s.EnvTemplateVo;
import cn.qg.holmes.service.k8s.EnvTemplateDetailService;
import cn.qg.holmes.service.k8s.EnvTemplateService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/env/template")
public class EnvTemplateController {

    @Autowired
    EnvTemplateService envTemplateService;

    @Autowired
    EnvTemplateDetailService envTemplateDetailService;

    @GetMapping("/list")
    public JsonResult getTemplateList(@RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<EnvTemplate> envTemplateIPage = new Page<>(pageNum, pageSize);
        IPage<EnvTemplate> IPage = envTemplateService.page(envTemplateIPage);
        List<EnvTemplate> envTemplateList = IPage.getRecords();
        List<EnvTemplateVo> envTemplateVoList = new ArrayList<>();
        QueryWrapper<EnvTemplateDetail> queryWrapper = new QueryWrapper<>();
        for (EnvTemplate envTemplate: envTemplateList) {
            EnvTemplateVo envTemplateVo = new EnvTemplateVo();
            envTemplateVo.setEnvTemplate(envTemplate);

            queryWrapper.eq("template_id", envTemplate.getId());
            List<EnvTemplateDetail> envTemplateDetailList = envTemplateDetailService.list(queryWrapper);
            envTemplateVo.setEnvTemplateDetailList(envTemplateDetailList);
            envTemplateVoList.add(envTemplateVo);
            queryWrapper.clear();
        }
        Map<String, Object> map = new HashMap<>();
        map.put("total",  IPage.getTotal());
        map.put("list", envTemplateVoList);
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 获取所有的模板及其关联的服务
     * @return
     */
    @GetMapping("/getAll")
    public JsonResult getTemplateByName() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<EnvTemplate> envTemplateList = envTemplateService.list();
        QueryWrapper<EnvTemplateDetail> queryWrapper = new QueryWrapper<>();
        for (EnvTemplate envTemplate: envTemplateList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", envTemplate.getId());
            map.put("name", envTemplate.getName());
            map.put("updateTime", envTemplate.getUpdateTime());
            queryWrapper.eq("template_id", envTemplate.getId());
            List<EnvTemplateDetail> envTemplateDetailList = envTemplateDetailService.list(queryWrapper);
            for (EnvTemplateDetail envTemplateDetail: envTemplateDetailList) {
                List<EnvTemplateDetail> envTemplateDetailListTemp;
                if (map.containsKey(envTemplateDetail.getLabel())) {
                    envTemplateDetailListTemp = (List<EnvTemplateDetail>) map.get(envTemplateDetail.getLabel());
                } else {
                    envTemplateDetailListTemp = new ArrayList<>();
                }
                envTemplateDetailListTemp.add(envTemplateDetail);
                map.put(envTemplateDetail.getLabel(), envTemplateDetailListTemp);
            }
            queryWrapper.clear();
            resultList.add(map);
        }
        return JsonResult.buildSuccessResult(resultList);
    }

    /**
     * 新建模板
     * @param envTemplateVo 模板虚拟实体类
     * @return
     */
    @PostMapping("/create")
    public JsonResult saveEnvTemplate(@RequestBody EnvTemplateVo envTemplateVo) {
        EnvTemplate envTemplate = envTemplateVo.getEnvTemplate();
        QueryWrapper<EnvTemplate> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", envTemplate.getName());
        if (envTemplateService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("模板已存在！", false);
        }
        // 保存模板
        if (!envTemplateService.save(envTemplate)) {
            return JsonResult.buildErrorStateResult("模板创建失败！", false);
        }
        // 模板详情列表设置模板id
        Integer templateId = envTemplateService.getOne(queryWrapper).getId();
        List<EnvTemplateDetail> envTemplateDetailList = envTemplateVo.getEnvTemplateDetailList();
        for (EnvTemplateDetail envTemplateDetail: envTemplateDetailList) {
            envTemplateDetail.setTemplateId(templateId);
        }
        // 保存模板详情
        if (!envTemplateDetailService.saveBatch(envTemplateDetailList)) {
            return JsonResult.buildErrorStateResult("模板详情保存失败！", false);
        }
        return JsonResult.buildSuccessResult(true);
    }

    /**
     * 编辑模板及模板详情
     * @param envTemplateVo 模板列表
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifyEnvTemplate(@RequestBody EnvTemplateVo envTemplateVo) {
        EnvTemplate envTemplate = envTemplateVo.getEnvTemplate();
        if (!envTemplateService.updateById(envTemplate)) {
            return JsonResult.buildErrorStateResult("模板更新失败！", false);
        }
        // 参数传过来的列表
        List<EnvTemplateDetail> envTemplateDetailList = envTemplateVo.getEnvTemplateDetailList();
        // 查询出数据库里该模板的所有条目
        QueryWrapper<EnvTemplateDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("template_id", envTemplate.getId());
        List<EnvTemplateDetail> envTemplateDetailListDb = envTemplateDetailService.list(queryWrapper);

        // 删除传参里没有的
        for (EnvTemplateDetail envTemplateDetailDb: envTemplateDetailListDb) {
            boolean delete = true;
            for (EnvTemplateDetail envTemplateDetail: envTemplateDetailList) {
                if (envTemplateDetail.getId() != null) {
                    if (envTemplateDetail.getId().equals(envTemplateDetailDb.getId())) {
                        delete = false;
                        break;
                    }
                }
            }
            if (delete) {
                envTemplateDetailService.removeById(envTemplateDetailDb.getId());
            }
        }
        // 剩余的批量新增/修改
        if (!envTemplateDetailService.saveOrUpdateBatch(envTemplateDetailList)) {
            return JsonResult.buildErrorStateResult("更新模板详情失败！", false);
        }
        return JsonResult.buildSuccessResult("模板更新成功");
    }

    /**
     *
     * @param templateId 模板id
     * @return
     */
    @PostMapping("/delete")
    public JsonResult deleteEnvTemplate(@RequestParam Integer templateId) {
       if (!envTemplateService.removeById(templateId)) {
           return JsonResult.buildErrorStateResult("模板删除失败！", false);
       }
       QueryWrapper<EnvTemplateDetail> queryWrapper = new QueryWrapper<>();
       queryWrapper.eq("template_id", templateId);
       if (!envTemplateDetailService.remove(queryWrapper)) {
           return JsonResult.buildErrorStateResult("模板详情删除失败", false);
       }
       return JsonResult.buildSuccessResult("模板删除成功！");
    }
}
