package cn.qg.holmes.encrypt;

import cn.qg.holmes.encrypt.yeebao.Aes;
import cn.qg.holmes.encrypt.yeebao.Rsa;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Component
public class YeebaoEncryptConvertor implements EncryptConvertor {

    @Value("${yeebao.private.key}")
    private String privateKey;
    private String aesKey = null;
    private String encryptKey = null;

    /**
     * 易宝加密
     * @param response
     * @return
     */
    @Override
    public String encrypt(String response) {
        try {
            Map responseMap = JSON.parseObject(response, Map.class);
            Map<String, Object> signData = new HashMap<>();
            responseMap.put("sign", Rsa.sign(response, privateKey));
            signData.put("encryptkey", encryptKey);
            signData.put("data", Aes.encryptToBase64(JSON.toJSONString(responseMap), aesKey));
            return JSON.toJSONString(signData);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 易宝解密
     * @param request Http请求的request
     * @return
     */
    @Override
    public String decrypt(String request) {
        try {
            Map requestMap = JSON.parseObject(request, Map.class);
            encryptKey = requestMap.get("encryptkey").toString();
            aesKey = Rsa.decrypt(encryptKey, privateKey);
            return Aes.decryptFromBase64((String) requestMap.get("data"), aesKey);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
