package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.Interface;
import cn.qg.holmes.entity.auto.SceneTestcase;
import cn.qg.holmes.mapper.auto.SceneTestcaseMapper;
import cn.qg.holmes.service.auto.AutoUtilsService;
import cn.qg.holmes.service.auto.InterfaceService;
import cn.qg.holmes.service.auto.SceneTestcaseService;
import cn.qg.holmes.service.auto.TestcaseService;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author libo
 * created at 2021-03-30
 */
@Service
@Slf4j
public class SceneTestcaseServiceImpl extends ServiceImpl<SceneTestcaseMapper, SceneTestcase> implements SceneTestcaseService {

    @Autowired
    SceneTestcaseMapper sceneTestcaseMapper;

    @Autowired
    TestcaseService testcaseService;

    @Autowired
    InterfaceService interfaceService;

    @Autowired
    AutoUtilsService autoUtilsService;

    @Override
    public void executeSceneTestcase(Integer sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("scene_id", sceneId);
        queryWrapper.orderByAsc("sequence");
        List<SceneTestcase> sceneTestcaseList =  sceneTestcaseMapper.selectList(queryWrapper);
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            sceneTestcaseExecution(sceneId, sceneTestcase.getInterfaceId());
        }
    }

    public String sceneTestcaseExecution(Integer sceneId, Integer interfaceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("scene_id", sceneId);
        queryWrapper.eq("interface_id", interfaceId);
        SceneTestcase sceneTestcase = sceneTestcaseMapper.selectOne(queryWrapper);
        Interface anInterface = interfaceService.getById(interfaceId);
        String url = anInterface.getUrl();
        log.info("开始执行接口：{}", url);
        String method = anInterface.getMethod().toUpperCase();
        String paramType = anInterface.getParamType();
        String headers = sceneTestcase.getHeaders();
        String parameters = sceneTestcase.getParameters();
        String variables = sceneTestcase.getVariables();
        String extract = sceneTestcase.getExtract();
        String validate = sceneTestcase.getValidate();
        Map<String, String> parameterMap = JSON.parseObject(parameters, Map.class);
        Map<String, String> headersMap = JSON.parseObject(headers, Map.class);
        if (variables != null && !variables.isEmpty() && parameters != null && !parameters.isEmpty()) {
            parameterMap = autoUtilsService.replaceParameters(parameters, variables);
        }
        if (variables != null && !variables.isEmpty() && headers != null && !headers.isEmpty()) {
            headersMap = autoUtilsService.replaceParameters(headers, variables);
        }
        List<Map> validateList = new ArrayList<>();
        if (validate != null && !validate.isEmpty()) {
            validateList = JSON.parseArray(validate, Map.class);
        }
        String response = "";
        switch (method) {
            case "GET":
                response = HttpClientUtils.doGet(url, headersMap, parameterMap);
                break;
            case "POST":
                if (paramType.equals("json")) {
                    response = HttpClientUtils.doPostJson(url, headersMap, JSON.toJSONString(parameterMap));
                } else if (paramType.equals("form")) {
                    response = HttpClientUtils.doPost(url, headersMap, parameterMap);
                }
                break;
            default:
                log.info("暂不支持该请求方法：{}", method);
                break;
        }
        // 进行断言
        if (!validateList.isEmpty()) {
            autoUtilsService.assertResponse(response, validateList);
        }
        // 解析响应
        if (extract != null && !extract.isEmpty()) {
            autoUtilsService.extractResponse(response, extract);
        }
        return response;
    }

}
