package cn.qg.holmes.controller.auto;

import cn.qg.holmes.service.auto.SceneTestcaseService;
import cn.qg.holmes.service.auto.TestcaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("/execute")
public class TestExecutionController {

    @Autowired
    TestcaseService testcaseService;

    @Autowired
    SceneTestcaseService sceneTestcaseService;

    @GetMapping("/testcase")
    public void testSingleTestcase(@RequestParam Integer testcaseId) {
        testcaseService.singleTestcaseExecutor(testcaseId);
    }

    @GetMapping("/scene")
    public void testScene(@RequestParam Integer sceneId) {
        sceneTestcaseService.executeSceneTestcase(sceneId);
    }
}
