package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.Interface;
import cn.qg.holmes.entity.auto.Testcase;
import cn.qg.holmes.mapper.auto.TestcaseMapper;
import cn.qg.holmes.service.auto.AutoUtilsService;
import cn.qg.holmes.service.auto.InterfaceService;
import cn.qg.holmes.service.auto.TestcaseService;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author libo
 * created at 2021-03-30
 */
@Service
@Slf4j
public class TestcaseServiceImpl extends ServiceImpl<TestcaseMapper, Testcase> implements TestcaseService {

    @Autowired
    TestcaseMapper testcaseMapper;

    @Autowired
    InterfaceService interfaceService;

    @Autowired
    AutoUtilsService autoUtilsService;

    @Override
    public String singleTestcaseExecutor(Integer testcaseId) {
        Testcase testcase = testcaseMapper.selectById(testcaseId);
        Interface anInterface = interfaceService.getById(testcase.getInterfaceId());
        String url = anInterface.getUrl();
        String method = anInterface.getMethod().toUpperCase();
        String paramType = anInterface.getParamType();
        String headers = testcase.getHeaders();
        String parameters = testcase.getParameters();
        String testcaseName = testcase.getName();
        String variables = testcase.getVariables();
        String extract = testcase.getExtract();
        String validate = testcase.getValidate();
        // 参数准备
        Map<String, String> parameterMap = JSON.parseObject(parameters, Map.class);
        Map<String, String> headersMap = JSON.parseObject(headers, Map.class);
        if (variables != null && !variables.isEmpty() && parameters != null && !parameters.isEmpty()) {
            parameterMap = autoUtilsService.replaceParameters(parameters, variables);
        }
        if (variables != null && !variables.isEmpty() && headers != null && !headers.isEmpty()) {
            headersMap = autoUtilsService.replaceParameters(headers, variables);
        }
        List<Map> validateList = new ArrayList<>();
        if (validate != null && !validate.isEmpty()) {
            validateList = JSON.parseArray(validate, Map.class);
        }
        String response = "";
        // 发起http请求
        switch (method) {
            case "GET":
                response = HttpClientUtils.doGet(url, headersMap, parameterMap);
                break;
            case "POST":
                if (paramType.equals("json")) {
                    response = HttpClientUtils.doPostJson(url, headersMap, JSON.toJSONString(parameterMap));
                } else if (paramType.equals("form")) {
                    response = HttpClientUtils.doPost(url, headersMap, parameterMap);
                }
                break;
            default:
                log.info("暂不支持该请求方法：{}", method);
                break;
        }
        log.info("用例:{}, 返回为：{}", testcaseName, response);
        // 进行断言
        if (!validateList.isEmpty()) {
            autoUtilsService.assertResponse(response, validateList);
        }
        // 解析响应
        if (extract != null && !extract.isEmpty()) {
            autoUtilsService.extractResponse(response, extract);
        }
        return response;
    }

}
