package cn.qg.holmes.service.reconciliation;

import cn.qg.holmes.entity.reconciliation.WxPayBillData;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.hash.Hashing;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

import java.util.*;

import static com.google.common.base.Charsets.UTF_8;

/**
 * 微信支付账单服务
 *
 * @author libo
 * 2022-02-21
 */
@Slf4j
@Component
public class WxPayBillService {

    private final String WX_API_KEY = "77f7565be7d8992ab882d4dc31271c71";
    private final String WX_BILL_DOWNLOAD_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private final String WX_FUND_FLOW_DOWNLOAD_URL = "https://api.mch.weixin.qq.com/pay/downloadfundflow";

    /**
     * https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_6
     * 下载微信支付交易账单
     *
     * @param billDate 下载对账单的日期，格式：20140603
     * @param billType ALL（默认值），返回当日所有订单信息（不含充值退款订单）SUCCESS，返回当日成功支付的订单（不含充值退款订单）, REFUND，返回当日退款订单（不含充值退款订单,RECHARGE_REFUND，返回当日充值退款订单
     * @return
     */
    public String downloadTradeBillFile(String billDate, String billType) {
        log.info("开始下载微信支付交易账单，账单日期：{}, 账单类型：{}", billDate, billType);
        String randomString = UUID.randomUUID().toString().replace("-", "");

        TreeMap<String, Object> treeMap = new TreeMap<>();
        treeMap.put("appid", "wx75d5a207551d0b4d");
        treeMap.put("mch_id", "1604055791");
        treeMap.put("nonce_str", randomString);
        treeMap.put("bill_date", billDate);
        treeMap.put("bill_type", billType);
        treeMap.put("sign", md5Sign(treeMap));

        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(WX_BILL_DOWNLOAD_URL);
        CloseableHttpResponse response = null;
        try {
            httpPost.setHeader("Content-type", "text/xml");
            String params = mapToXml(treeMap);
            HttpEntity entity = new StringEntity(params);
            httpPost.setEntity(entity);
            response = httpClient.execute(httpPost);

            if (response.getStatusLine().getStatusCode() == 200) {
                String content = EntityUtils.toString(response.getEntity(), "UTF-8");
                return content;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }


    /**
     * 解析微信交易账单
     *
     * @param content  微信交易账单内容
     * @param billType 账单类型
     * @return
     */
    public List<WxPayBillData> parseTradeBill(String content, String billType) {
        log.info("开始解析微信账单文件.");
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        String[] tradeBillArray = content.split("\n");
        List<WxPayBillData> wxTradeBillDataList = new ArrayList<>();

        // 三种类型账单下载的文件格式不一样，分别处理
        if (StringUtils.equals(billType, "ALL")) {
            // 第一行为表头，最后两行为统计数据，均忽略
            for (int i = 1; i < tradeBillArray.length - 2; i++) {
                String[] dataArray = tradeBillArray[i].replace("`", "").split(",");

                WxPayBillData wxTradeBillData = new WxPayBillData();
                wxTradeBillData.setTradeTime(dataArray[0]);
                wxTradeBillData.setWxOrderNo(dataArray[5]);
                wxTradeBillData.setMerchantOrderNo(dataArray[6]);
                wxTradeBillData.setTradeType(dataArray[8]);
                wxTradeBillData.setTradeStatus(dataArray[9]);
                wxTradeBillData.setOrderAmount(dataArray[24]);

                wxTradeBillData.setWxRefundOrderNo(dataArray[14]);
                wxTradeBillData.setMerchantRefundOrderNo(dataArray[15]);
                wxTradeBillData.setRefundAmount(dataArray[16]);
                wxTradeBillData.setRefundType(dataArray[18]);
                wxTradeBillData.setRefundStatus(dataArray[19]);

                wxTradeBillDataList.add(wxTradeBillData);

            }
        }

        if (StringUtils.equals(billType, "SUCCESS")) {
            for (int i = 1; i < tradeBillArray.length - 2; i++) {
                String[] dataArray = tradeBillArray[i].replace("`", "").split(",");

                WxPayBillData wxTradeBillData = new WxPayBillData();
                wxTradeBillData.setTradeTime(dataArray[0]);
                wxTradeBillData.setWxOrderNo(dataArray[5]);
                wxTradeBillData.setMerchantOrderNo(dataArray[6]);
                wxTradeBillData.setTradeType(dataArray[8]);
                wxTradeBillData.setTradeStatus(dataArray[9]);
                wxTradeBillData.setOrderAmount(dataArray[18]);

                wxTradeBillDataList.add(wxTradeBillData);
            }
        }

        if (StringUtils.equals(billType, "REFUND")) {
            for (int i = 1; i < tradeBillArray.length - 2; i++) {
                String[] dataArray = tradeBillArray[i].replace("`", "").split(",");

                WxPayBillData wxTradeBillData = new WxPayBillData();
                wxTradeBillData.setTradeTime(dataArray[0]);
                wxTradeBillData.setWxOrderNo(dataArray[5]);
                wxTradeBillData.setMerchantOrderNo(dataArray[6]);
                wxTradeBillData.setTradeType(dataArray[8]);
                wxTradeBillData.setTradeStatus(dataArray[9]);
                wxTradeBillData.setWxRefundOrderNo(dataArray[16]);
                wxTradeBillData.setMerchantRefundOrderNo(dataArray[17]);
                wxTradeBillData.setRefundAmount(dataArray[18]);
                wxTradeBillData.setRefundType(dataArray[20]);
                wxTradeBillData.setRefundStatus(dataArray[21]);

                wxTradeBillDataList.add(wxTradeBillData);
            }
        }
        return wxTradeBillDataList;
    }

    /**
     * md5签名
     *
     * @param value
     * @return
     */
    public String md5Sign(Object value) {
        JSONObject jsonMap = JSON.parseObject(JSON.toJSONString(value));
        TreeMap<String, Object> treeMap = new TreeMap<>(jsonMap);
        String signStr = Joiner.on("&").withKeyValueSeparator("=").join(treeMap);
        return Hashing.md5().newHasher()
                .putString(signStr + "&key=" + WX_API_KEY, UTF_8)
                .hash()
                .toString()
                .toUpperCase();
    }

    public String mapToXml(SortedMap<String, Object> sortedMap) {
        StringBuffer sb = new StringBuffer("<xml>");
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = sortedMap.get(key);
            sb.append("<" + key + ">");
            sb.append(value);
            sb.append("</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }
}
