package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.effect.ClearCache;
import cn.qg.holmes.service.effect.ClearCacheService;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/effect")
public class EffectController {

    @Autowired
    ClearCacheService clearCacheService;

    /**
     * 获取清缓存实体列表
     * @return
     */
    @GetMapping("/cacheList")
    public JsonResult getCacheList() {
        return JsonResult.buildSuccessResult(clearCacheService.list());
    }

    /**
     * 清缓存
     * @param id 缓存id
     * @param namespace 环境
     * @return
     */
    @GetMapping("/clearcache")
    public JsonResult clearCache(Integer id, String namespace) {
        ClearCache clearCache = clearCacheService.getById(id);
        String url = clearCache.getUrl();
        if (url.contains("{NAMESPACE}")) {
            if (StringUtils.isEmpty(namespace)) {
                return JsonResult.buildErrorStateResult("请先选择环境！", false);
            } else {
                url = url.replace("{NAMESPACE}", namespace);
            }
        }
        String result = HttpClientUtils.doGet(url);
        return JsonResult.buildSuccessResult(JSON.parseObject(result, Map.class));
    }
}
