package cn.qg.holmes.task;

import cn.qg.holmes.utils.JenkinsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 数据库同步定时任务
 */
@Slf4j
@Component
public class DbSyncTask {

    @Autowired
    JenkinsService jenkinsService;

    @Scheduled(cron = "0 0 12 * * ?")
    public void getDbInfoFromSourceJob() {
       jenkinsService.buildDbDailyBackupJob();
    }
}
