package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.entity.auth.UserInfoVo;
import cn.qg.holmes.service.auth.LoginService;
import cn.qg.holmes.service.auth.TokenService;
import cn.qg.holmes.service.auth.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/auth")
public class LoginController {

    @Autowired
    LoginService loginService;

    @Autowired
    TokenService tokenService;

    @Autowired
    UserService userService;

    @PostMapping("/login")
    public JsonResult login(String username, String password) {
        boolean loginResult = loginService.login(username, password);
        if (!loginResult) {
            return JsonResult.buildErrorStateResult("用户名或密码错误", false);
        }
        User user = userService.getUserByUsername(username);
        // 用户不存在，则创建新用户
        if (user == null) {
            User newUser = new User();
            newUser.setUsername(username);
            newUser.setPassword(DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8)));
            userService.save(newUser);
        }
        user = userService.getUserByUsername(username);
        String token = tokenService.generateToken(user.getId());
        Map<String, Object> map = new HashMap<>();
        map.put("token", token);
        map.put("data", userService.getUserInfoByUsername(username));
        return JsonResult.buildSuccessResult(map);
    }

    @PostMapping("/logout")
    public JsonResult logout(String token) {
        tokenService.invalidateToken(token);
        return JsonResult.buildSuccessResult("登出成功！", true);
    }

    @GetMapping("/info")
    public JsonResult getInfo(String username) {
        UserInfoVo userInfoVo = userService.getUserInfoByUsername(username);
        return JsonResult.buildSuccessResult(userInfoVo);
    }
}
