package cn.qg.holmes.entity.auto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 场景用例实体类
 * @author libo
 */
@Data
@TableName("scene_testcase")
public class SceneTestcase {
    @TableId(type = IdType.AUTO)
    private Integer id;
    private Integer sceneId;
    private Integer interfaceId;
    private String preAction;
    private String postAction;
    private String headers;
    private String parameters;
    private String variables;
    private String extract;
    private String validate;
    private Integer sequence;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    @TableField(exist = false)
    private String sceneName;
    @TableField(exist = false)
    private String interfaceName;
    @TableField(exist = false)
    private String moduleName;
}
