import org.qg.docker.*
import java.time.*

def getTime(){
	LocalDateTime t = LocalDateTime.now();
	return t as String
}

def call(body) {
	
	  sh 'echo $MAKE_USER'
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def originSystemName = t[1]
    def systemName = originSystemName.toLowerCase()

    echo "====JOB_NAME : ${env.JOB_NAME}"
		
		def harborGroup = "library"
/*		def workspace = "/home/quant_ group/jenkins_home/workspace/${env.JOB_NAME}"*/
    
    def imageTag
		def timeNow = getTime()
    def contextDir
    def _stage = new org.qg.docker.StageBucket()
    def _utils = new org.qg.docker.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {        
        try {
            ansiColor('xterm') {
								
                
                  dir (systemName) {  
        
                        stage('Checkout & Build') {
											    git_path = project_attr(systemName)["gitPath"]
													if(git_path =="git@gitabc.xyqb.com:data-riskcontrol/urge-dispatcher.git"){
														git_path = "git@gitabc.xyqb.com:data-riskcontrol/urge_dispatcher.git"
													}
													
											    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
													
													
													withMaven() {
 
													      bat 'mvn clean package -P test -D maven.test.skip=true'
 
													    }
													
                        }
											}
                              
									 
            }   
        } catch (err) {
						sleep 100
            ansiColor('xterm') {
                if (imageTag) {
                    _stage.clean_images(imageTag)
                }
                currentBuild.result = 'FAILED'
                _utils.beautyEcho(err, "fail")
                throw err
            }
        }
    }
}


@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}