import org.qg.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER
    
    t = gitRepo.split("/")
    def gitGroup = t[0]
    def systemName = t[1]

    def harborGroup = "library"
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def contextDir
    def _stage = new org.qg.Stage()
    def _utils = new org.qg.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        try {
            stage('Checkout') {
                contextDir = _utils.contextDir(workspace)
                _stage.checkout(branchName, contextDir, gitRepo)
            }

            stage('Build') {
                _stage.build(namespace, systemName, contextDir)
            }

            stage('Docker Build And Push') {
                _stage.docker_build_and_push(buildNumber, branchName, contextDir)
            }

            stage('Deploy') {
                _stage.deploy(namespace, systemName, imageTag, isDeploy)
            }

            stage("Clean") {
                _stage.clean(contextDir)
            }
        } catch (err) {
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}