import org.qg.docker.*
import java.time.*

def getTime(){
	LocalDateTime t = LocalDateTime.now();
	return t as String
}

def call(body) {
	
	  
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def originSystemName = t[1]
    def systemName = originSystemName.toLowerCase()

    echo "====JOB_NAME : ${env.JOB_NAME}"
		
		def harborGroup = "library"
/*		def workspace = "/home/quant_ group/jenkins_home/workspace/${env.JOB_NAME}"*/
    
    def imageTag
		def timeStemp = new Date().format("yyyyMMddHHmmss")
    def _stage = new org.qg.docker.StageBucket()
    def _utils = new org.qg.docker.Utils()
    def contextDir = "/home/quant_group/pacakge/${systemName}-${timeStemp}"
		def contextDir_app_properties = "${contextDir}/app-properties"
		def contextDir_apollo_settings = "${contextDir}/apollo-settings"
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {   
			  
			try { 
				sh "mkdir -p ${contextDir}"
				sh "mkdir -p ${contextDir_app_properties}"
				sh "mkdir -p ${contextDir_apollo_settings}"
				
				withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
					docker.image("192.168.4.36/baseimg/jenkins-slave:2018040302").inside('-v /root/.m2:/root/.m2 -v /home/quant_group/qg-dockerfiles:/home/quant_group/qg-dockerfiles -v /home/quant_group/pacakge/:/home/quant_group/pacakge/'){
						git_path = project_attr(systemName)["gitPath"]
						if(git_path =="git@gitabc.xyqb.com:data-riskcontrol/urge-dispatcher.git"){
							git_path = "git@gitabc.xyqb.com:data-riskcontrol/urge_dispatcher.git"
						}							

						git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path


						sh 'mvn clean package -P test -D maven.test.skip=true'
						applicaton_properties = "/home/quant_group/qg-repository/java/${systemName}.properties"
						
						echo applicaton_properties
						
						sh "if [ -f \"${applicaton_properties}\"]; then cp -rf ${applicaton_properties} ${contextDir_app_properties}/application.properties; fi"
						
						sh "cp -rf /home/quant_group/qg-dockerfiles/templates_new/java/* ${contextDir}"
						sh "cp target/*.jar ${contextDir}/app.jar"
					
					}
					
					
			    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
					
			    k8sSystemName = systemName.replaceAll("_","-")
			    safeBranchName = branchName.replaceAll(regex,"_")
			    defaultSystemName = "project"	
					timeStemp = new Date().format("yyyyMMddHHmmss")

			    imageTag = "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${timeStemp}"
					
			    withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
			        def image = docker.build(imageTag, "--build-arg BUILD_TIME=${timeStemp} --build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${systemName} --build-arg BRANCH_NAME=${branchName} --build-arg SAFE_SYSTEM_NAME=${defaultSystemName} ${contextDir}")
			        image.push()
        
			        if (branchName == "master" || branchName == "master--master") {
			            image.push('latest')
			        }
            
			    }
					
					
				}	
				
		   				
			}catch (err) {
/*				sh "rm -rf ${contextDir}"*/
            ansiColor('xterm') {
                /*if (imageTag) {
                    _stage.clean_images(imageTag)
                }*/
                currentBuild.result = 'FAILED'
                /*_utils.beautyEcho(err, "fail")*/
                throw err
            }
        }
    }
}


@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}