def call(body) {
    
    def config = [:]
    def env = body.env
    def namespace = env.namespace
    def tagName = env.tag_name
    def dataCenter = env.data_center
    def hosts = env.hosts
    def action = env.action
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        stage('Clean') {
            deleteDir()
        }
        
        stage('Build') {
            sh "ansible-playbook /etc/ansible/build.yml -e project_name=${config.envType}.${projectName} -e namespace=${namespace} -e tag_name=${tagName} -vv"
        }

        stage('Deploy') {
            sh "ansible-playbook /etc/ansible/nginx_remove.yml -e project_name=${config.envType}.${projectName} -e data_center=${dataCenter} -e machines=${hosts} -vv"
            
            
            env.RELEASE_ACTION = input message: '请选择下一步部署动作', ok: '确认',
                    parameters: [choice(name: 'RELEASE_SCOPE', choices: 'Deploy\nRollback', description: '请谨慎选择你要进行的操作')]
                    
            if (env.RELEASE_ACTION == "Deploy") {
                sh "ansible-playbook /etc/ansible/${action}.yml -e project_name=${config.envType}.${projectName}  -e data_center=${dataCenter} -e machines=${hosts} -vv"
            }else{
                sh "ansible-playbook /etc/ansible/nginx_add.yml -e project_name=${config.envType}.${projectName} -e data_center=${dataCenter} -e machines=${hosts} -vv"
            }
            
        }
    }
}