// src/org/foo/Stage.groovy
package org.qg.docker_new;
import org.qg.docker_new.Utils;
import groovy.json.JsonSlurperClassic;

def _utils() { 
	return new org.qg.docker_new.Utils();
}

def debug() {
    _utils().beautyEcho("debug", "info")
}

def contextMkdir(key) {
    uuid = UUID.randomUUID().toString()
    contextDir = "/home/quant_group/package/${key}"
	sh "mkdir -p ${contextDir}"
    return contextDir
}

def imageTag(harborGroup,k8sSystemName,safeBranchName,timeStemp){
	return "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${timeStemp}"
}

def before_prepare() {    
    sh "cd /home/quant_group/qg-dockerfiles; git pull; cd -"
    sh "cd /home/quant_group/config_repository; git pull origin master; cd -"
}

def prepare_config(buildType,systemName, contextDir) {
	_utils().beautyEcho("Prepare Config +++ type:${buildType} systemName:${systemName}", "info")
	switch (buildType) {
		case "java":
			prepare_java(systemName, contextDir)
			break
		case "nodejs":
			prepare_nodejs(systemName, contextDir)
			break
		case "python":
			prepare_python(systemName, contextDir) 
			break
		case "lua-ui":
			prepare_luaui(systemName, contextDir)
			break
		default:
			_utils().beautyEcho("未知的buildType: ${buildType}","fail")
			break
	}
}

def prepare_java(systemName, contextDir) {
	sh "cp -rf /home/quant_group/qg-dockerfiles/templates/java/* ${contextDir}"
	sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}/application.properties"
}

def prepare_nodejs(systemName, contextDir) {
	sh "cp -rf /home/quant_group/qg-dockerfiles/templates/nodejs/* ${contextDir}"
	sh "cp -rf /home/quant_group/config_repository/nodejs/${systemName}.js env.config.js"
}

def prepare_luaui(systemName, contextDir) {
	sh "cp -rf /home/quant_group/qg-dockerfiles/templates/lua-ui/* ${contextDir}"
	sh "cp -rf /home/quant_group/config_repository/lua-ui/lua/*.lua ${contextDir}"

	def isVhFileExist = fileExists "/home/quant_group/config_repository/lua-ui/nginx/${systemName}.vh.conf"
	if (isVhFileExist) {
	    sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/${systemName}.vh.conf ${contextDir}"
	}else{
	    sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/default.vh.conf ${contextDir}"
	}

	
	sh "cp -rf /home/quant_group/config_repository/lua-ui/config/${systemName}.js ${systemName}.env.config.js"
	
}

def prepare_python(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/python/${systemName}.ini ${contextDir}/config.ini"
}

def checkout(buildType,systemName, branchName) {
	_utils().beautyEcho("CheckOut +++ type:${buildType} systemName:${systemName} branchName:${branchName}", "info")
	switch(buildType){
		case "java":
			checkout_java(systemName, branchName)
			break                  
		case  "nodejs":
			checkout_nodejs(systemName, branchName)
			break
		case "python":
			checkout_python(systemName, branchName)
			break
		case "lua-ui":
			checkout_luaui(systemName, branchName)
			break                                
		default:
			echo "未知的buildType: ${cbuildType}"
			break
	}
}

def checkout_java(systemName, branchName) {
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
}

def checkout_python(systemName, branchName) {
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
}

def checkout_nodejs(systemName, branchName) {
		
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	
	currentPath = sh (script: 'pwd',returnStdout: true).trim()		
	def folder = new File( "${currentPath}/.git/hooks" )
    		
	if( !folder.exists()){
	    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
	    def bowerFile = fileExists './bower.json'
	    if (bowerFile) {
	        sh "bower install --allow-root"
	    }
	    sh "npm install"
	} else {
	    sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
	    sh "chmod +x .git/hooks/post-checkout"
	    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
		    
	}
    
}

def checkout_luaui(systemName, branchName) {
	echo "----------------------------"
	sh "whoami"
	echo "----------------------------"
	sh "cp -rf /home/quant_group/config_repository/lua-ui/npmrc/npmrc /root/.npmrc"
   
	_utils().beautyEcho("ui project : ${systemName}"  , "info")
	projectAttr = project_attr(systemName)
	gitPath = projectAttr["gitPath"]
	
	currentPath = sh (script: 'pwd',returnStdout: true).trim()	
	def folder = new File( "${currentPath}/.git/hooks" )
	
	def hookExist = folder.exists()
	if (hookExist){
		sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
		sh "chmod +x .git/hooks/post-checkout"
	}
		
	git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
	
	
	def nmfolder = new File( "${currentPath}/node_modules" )
	
	if (!nmfolder.exists()){
		sh "mkdir node_modules"
		sh "chmod -R 777 node_modules"
	}
	
	if(!hookExist){
		def bowerFile = fileExists './bower.json'
		if (bowerFile) {
		    sh "bower install --allow-root"
		}
		sh "npm install" 
	}	 
	    
}

def build(buildType,systemName, contextDir){
	
	_utils().beautyEcho("Build +++ type:${buildType} systemName:${systemName}", "info")
	switch(buildType){
    case "java":
        build_java(systemName, contextDir)
        break                  
    case  "nodejs":
        build_nodejs( systemName, contextDir)
        break
    case "python":
        build_python( systemName, contextDir)
        break
    case "lua-ui":
        build_luaui( systemName, contextDir)
        break                                
    default:
        echo "未知的buildType: ${buildType}"
        break
		}
		
		
}

def build_java(systemName, contextDir) {
	def projectAttr = project_attr(systemName)
		
	buildCmd = projectAttr["buildCmd"]
	jarFilePath = projectAttr["jarFilePath"]

	sh buildCmd
	sh "cp ${jarFilePath}/*.jar ${contextDir}/app.jar"
}

def build_nodejs( systemName, contextDir) {    
    def projectAttr = project_attr(systemName)

    configPath = projectAttr["configPath"]
    buildCmd = projectAttr["buildCmd"]
    configName = systemName
        
    sh "mv -f env.config.js ${configPath}"
    sh 'tar zcf dist.tgz ./*'
    sh "mv dist.tgz ${contextDir}"
}

def build_python( systemName, contextDir) {
    sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
    sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"
    sh 'tar zcf dist.tgz server/'
    sh "mv dist.tgz ${contextDir}"
}

def build_luaui( systemName, contextDir) {   
	 
	def projectAttr = project_attr(systemName)
	configPath = projectAttr["configPath"]
	buildCmd = projectAttr["buildCmd"]
	configName = systemName
	sh "mv -f ./${systemName}.env.config.js ${configPath}"
	sh buildCmd
	sh "tar zcf ${systemName}.tgz dist/"
	sh "mv ${systemName}.tgz ${contextDir}"
     
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}

def update_microservice(namespace, name, image, tier) {
	dest_url = "http://eos.quantgroups.com/api/qahome/update_microservice"
	
    response = httpRequest httpMode:"PUT",
      consoleLogResponseBody:true,
      contentType:"APPLICATION_JSON", 
      requestBody:"""{
        "namespace":"${namespace}",
        "name":"${name}",
				"image":"${image}",
				"tier":"${tier}"
      }""",
      url:dest_url
	
    def res_json = jsonParse(response.content)
    return res_json
}


def slaveImageRespority(buildEnv){
	//envType java8 java9 node7 node8
	
	switch(buildEnv){
		case "java8":
			return "192.168.4.36/baseimg/docker-jenkins-slave:2018041202"
			break
		case "java9":
			return null 
			break
		case "node7":
	    	return "192.168.4.36/baseimg/jenkins-node7-slave:2018041301"
			break
		case "node8":
			return "192.168.4.36/baseimg/jenkins-node8-slave:2018041301"
			break
		default :
			return "192.168.4.36/baseimg/docker-jenkins-slave:2018041202"
		}
	
}

def slaveImageArgs(buildType){
	def args = ""
	args += "-v /home/quant_group/qg-dockerfiles:/home/quant_group/qg-dockerfiles "
	args += "-v /home/quant_group/config_repository:/home/quant_group/config_repository "
	args += "-v /home/quant_group/package/:/home/quant_group/package/ "
	switch (buildType) {
		case "java":
			args += "-v /root/.m2:/root/.m2 "			
			break
			
		case "nodejs":
			args += "-v /root/.npm:/root/.npm:rw "
			args += "-v /root/.cache:/root/.cache:rw "
			args += "-v /root/.node-gyp:/root/.node-gyp:rw "
			break			
		case "python":		
			break
			
		case "lua-ui":
			args += "-v /root/.npm:/root/.npm:rw "
			args += "-v /root/.cache:/root/.cache:rw "
			args += "-v /root/.node-gyp:/root/.node-gyp:rw "			
			break
			
		default:			
			break
	}
	
	return args
	
}

def getDocketPackageImage(buildType,buildEnv){
	echo "getDocketPackageImage :${buildType}"

	def packageImageInfo=[:] 
	
	packageImageInfo["image"] = slaveImageRespority(buildEnv)
	packageImageInfo["args"] = slaveImageArgs(buildType)
	
	_utils().beautyEcho("image :"+ packageImageInfo["image"], "info")
	_utils().beautyEcho("args :"+ packageImageInfo["args"], "info")
	return packageImageInfo
}

def check_and_build(buildType,systemName,branchName,contextDir){
	
	def buildEnv =""
	switch(buildType){
		case "java":
			buildEnv ="java8"
			break
		case "lua-ui":
		//"xjd-ui","paycenter-ui"
			buildEnv = "node8"
			if(systemName in ["xyqb-ui"]){
				buildEnv ="node7"
			}
			break
		case "nodejs":
			buildEnv = "node8"			
			break
		default :
			buildEnv ="java8"
	}
	
	def pacegeDockerInfo = getDocketPackageImage(buildType,buildEnv)
	
	docker.image(pacegeDockerInfo["image"]).inside(pacegeDockerInfo["args"]){
		
		/*checkout code*/
		stage('Checkout') {
			checkout(buildType, systemName, branchName)
		}
		/*prepare config*/
		stage('Prepare') {
			prepare_config(buildType, systemName, contextDir)
		}
		/*build*/
		stage('Build'){
			build(buildType, systemName, contextDir)
		}
			
	}
}

def dockerbuild_and_push(imageTag,buildNumber,systemName,branchName,cluster,timeStemp){
	//systemName == originSystemName
	stage('Docker Build And Push') {
		withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
			def build_schema = "BUILD_TIME:${timeStemp}@BUILD_NUMBER:${buildNumber}@SYSTEM_NAME:${systemName}@BRANCH_NAME:${branchName}@CLUSTER:${cluster}"
			echo build_schema
			def args = ""
			args += "--build-arg BUILD_TIME=${timeStemp} "
			args += "--build-arg BUILD_NUMBER=${buildNumber} "
			args += "--build-arg SYSTEM_NAME=${systemName} "
			args += "--build-arg BRANCH_NAME=${branchName} "
			args += "--build-arg SAFE_SYSTEM_NAME=${systemName} "
			args += "--build-arg BUILD_SCHEMA=${build_schema} "
			def image = docker.build(imageTag, "${args} ${contextDir}")
		    image.push()

		    if (branchName == "master" || branchName == "master--master") {
		      image.push('latest')
		    }
		
			_utils().beautyEcho("镜像地址:${imageTag}", "info")

		}
	}

}

def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    
	stage('Deploy To K8s Cluster'){
	def deploy_job_info
    
	    if (isDeploy=="true") {
		    _utils().beautyEcho("[新集群][deployV2]将镜像更新到到Namespace:" + namespace, "info")
			update_microservice(namespace, systemName, imageTag, tier)
		
	    }else{
		      _utils().beautyEcho( "isDeploy == false，不执行deploy","info")
	    }
	}
}

/*def dockerbuild_and_push(timeNow, buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"

    k8sSystemName = systemName.replaceAll("_","-")
    safeBranchName = branchName.replaceAll(regex,"_")
    defaultSystemName = "project"
	  timeStemp = new Date().format("yyyyMMddHHmmss")

    imageTag = "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${timeStemp}"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_TIME=${timeNow} --build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${systemName} --build-arg BRANCH_NAME=${branchName} --build-arg SAFE_SYSTEM_NAME=${defaultSystemName} ${contextDir}")
            image.push()

            if (branchName == "master" || branchName == "master--master") {
                image.push('latest')
            }

        }
    }

    _utils().beautyEcho("镜像地址:${imageTag}", "info")
    return imageTag
}*/

def clean_images(imageTag,contextDir) {
	sh "rm -rf ${contextDir}"
	if (imageTag){
		sh "docker rmi -f \$(docker images -q ${imageTag})"
	}
}

