


def call(body) {
	
	ansiColor('xterm') {
		
			def harborGroup = "library"
			def _stage = new org.qg.docker_new.StageBucket()
			def _utils = new org.qg.docker_new.Utils()
	   
	    def config = [:]
	    def timeStemp = new Date().format("yyyyMMddHHmmss")
		
	    def env = body.env	    
	    def gitRepo = env.GIT_REPO
			def originBranchName = env.BRANCH_NAME
	    def namespace = env.NAMESPACE
	    def isDeploy = env.IS_DEPLOY
	    def buildNumber = env.BUILD_NUMBER
			def cluster = env.CLUSTER
    
		  // QG/XXX or QG--QG/systemName--systemName
			t = gitRepo.split("/")
	    def gitGroup = t[0]
			// systemName or systemName--systemName
			def originSystemName = t[1]	    
			// ["",""]
			def systemNames = originSystemName.split("--")
			def branchNames = originBranchName.split("--")
    	
			def contextDir
	    def imageTag     
		
	    body.resolveStrategy = Closure.DELEGATE_FIRST
	    body.delegate = config
	    body()

	    node {   
			  
				try { 
					echo config.buildType
					/*  1 */
					stage('Init') {
						_utils.beautyEcho("Init", "stage")
						contextDir = _stage.contextMkdir("${originSystemName}-${timeStemp}")
						_stage.before_prepare()
					}
									
					
				  /*  2 */
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
						_utils.beautyEcho("checkout & build < ${originSystemName} : ${originBranchName} >", "stage")
						

				    for(def i = 0; i<systemNames.length; i++){
							dir(systemNames[i]){
								_stage.check_and_build(config.buildType, systemNames[i], branchNames[i], contextDir)
								
							}
						}
				    
						_utils.beautyEcho("build over", "info")	
						
						
					}
					
					/*  3 */
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
						_utils.beautyEcho("make docker image", "stage")		
						
						def regex = "[`,./;\\[\\]&<>?:\"()|-]+"
				    def k8sSystemName = originSystemName.replaceAll("_","-")
				    def safeBranchName = originBranchName.replaceAll(regex,"_")
						imageTag = _stage.imageTag(harborGroup,k8sSystemName,safeBranchName,timeStemp)
												
						def _systemName = originSystemName.toLowerCase()											
						_stage.dockerbuild_and_push(imageTag,buildNumber,_systemName,originBranchName ,cluster,timeStemp)											
					
						_utils.beautyEcho("Deploy To K8s Cluster image: ${imageTag} to:${namespace}", "stage")											
						_stage.deploy(namespace, _systemName, imageTag, config.tier, isDeploy)
																				
						
						
					}
					
					/*  4 */
					stage('Clean'){
						_utils.beautyEcho("Clear Cache Tmp", "stage")											
						_stage.clean_images(imageTag,contextDir)																		
					}
								 				
				} catch (err) {
					_utils.beautyEcho(err, "fail")
					_stage.clean_images(imageTag,contextDir)					
					throw err			
	      }
	    }
		}
}




