// src/org/qg/ansible/Utils.groovy
package org.qg.ansible;
import java.util.ArrayList;
import java.util.List;

def partition(array, size) {
    def partitions = []
    int partitionCount = array.size() / size

    partitionCount.times { partitionNumber ->
        def start = partitionNumber * size 
        def end = start + size - 1
        partitions << array[start..end]    
    }

    if (array.size() % size) partitions << array[partitionCount * size..-1]
    return partitions    
}


def partList(al, fromIndex, size) {
    
    print "Original ArrayList Content: "+al
    
    partOne = new ArrayList<String>(al.subList(0, fromIndex))
    print "SubList stored in partOne: "+partOne

    partTwo = new ArrayList<String>(al.subList(fromIndex, size))
    print "SubList stored in partTwo: "+partTwo
    
    return [partOne, partTwo]
}