/*
	docker make pipeline for pipes
*/
def call(body) {
	
	ansiColor('xterm') {
				
		def _stage = new org.qg.docker_new.StageBucket()
		def _utils = new org.qg.docker_new.Utils()
	   
		
		//def timeStemp = new Date().format("yyyyMMddHHmmss")
		
		def env = body.env	
		
		def systemName = env.GIT_PRO_NAME		
		def branchName = env.BRANCH_NAME
		def buildType = env.BUILD_TYPE == "ui" ? "lua-ui" : env.BUILD_TYPE == "node" ? "nodejs" : env.BUILD_TYPE
		/*		def namespace = env.NAMESPACE*/
		/*		def isDeploy = env.IS_DEPLOY*/
		def buildNumber = env.BUILD_NUMBER  // 
		def cluster = env.CLUSTER   // dev 
		def harborHost =env.HARBOR_HOST //192.168.4.4
		def imageTag =env.IMAGE_TAG // Library/xyqb:master-1213123
		def timeStemp = env.TIMESTEMP
				
		def imageTagInfo =[harborHost:"http://${harborHost}",imageTag:"${harborHost}/${imageTag}"] 
		
		def contextDir 
		def branchHashCode
				
		def schemaInfo = ""+
			"\033[32m############################################\n"+
			"#  GIT_PRO_NAME:${systemName}\n"+
			"#  BRANCH_NAME:${branchName}\n"+
			"#  BUILD_TYPE:${buildType}\n"+
			"#  HARBOR_HOST:${harborHost}\n"+
			"#  IMAGE_TAG:${imageTag}\n"+
			"############################################\033[0m"
		ansiColor('xterm') {
			echo schemaInfo
		}
		
		node {   
			
			try { 
				contextDir = _stage.contextMkdir("${systemName}-${timeStemp}")
				/*  1 */
				stage('Init') {
					_utils.beautyEcho("Init", "stage")					
					_stage.init_dependency()
					_stage.init_image_dependency(buildType,systemName,contextDir)
				}
						
			  
				withDockerServer([uri: "tcp://172.29.1.15:2375/"]) {
					_utils.beautyEcho("checkout & build < ${systemName} : ${branchName} >", "stage")
					dir(systemName){
						branchHashCode = _stage.check_and_build(buildType, systemName, branchName, contextDir)
					}
					_utils.beautyEcho("build over", "info")	
				}
				
	
				/*  3 */
				withDockerServer([uri: "tcp://172.29.1.15:2375/"]) {
					_utils.beautyEcho("make docker image", "stage")		
					
					_stage.dockerbuild_and_push(imageTagInfo,buildNumber,systemName,branchName ,cluster,timeStemp,contextDir,branchHashCode)																	
					
				}
	
				/*  4 */
				stage('Clean'){
					_utils.beautyEcho("Clear Cache Tmp", "stage")											
					_stage.clean_images(imageTagInfo["imageTag"],contextDir)																		
				}
								 				
			} catch (err) {
				_utils.beautyEcho(err, "fail")
				_stage.clean_images(imageTagInfo["imageTag"],contextDir)
												
				throw err			
			}
	    }
		
	}
}



