// src/org/foo/Stage.groovy
package org.qg.docker;
import org.qg.docker.Utils;
import groovy.json.JsonSlurperClassic;

def _utils(){
    def _utils = new org.qg.docker.Utils();
    return _utils
}

def debug() {
    _utils().beautyEcho("debug", "info")
}

def before_prepare(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles; git pull; cd -"
    sh "cd /home/quant_group/config_repository; git pull origin master; cd -"
}

def prepare_java(systemName, contextDir) {
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/java ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}/application.properties"
}

def prepare_nodejs(systemName, contextDir) {
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/nodejs ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/nodejs/${systemName}.js env.config.js"
}

def prepare_luaui(systemNames, contextDir) {
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/lua-ui ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/lua-ui/lua/*.lua ${contextDir}"
    
    def isVhFileExist = fileExists "/home/quant_group/config_repository/lua-ui/nginx/${systemNames}.vh.conf"
    if (isVhFileExist) {
        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/${systemNames}.vh.conf ${contextDir}"
    }else{
        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/default.vh.conf ${contextDir}"
    }

    arrSystem = systemNames.split("--")
    for (systemName in arrSystem) {
        sh "cp -rf /home/quant_group/config_repository/lua-ui/config/${systemName}.js ${systemName}.env.config.js"
    }
}

def prepare_python(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/python/${systemName}.ini ${contextDir}/config.ini"
}

def checkout(branchName, systemName) {
	  
    git_path = project_attr(systemName)["gitPath"]
		if(git_path =="git@gitabc.xyqb.com:data-riskcontrol/urge-dispatcher.git"){
			git_path = "git@gitabc.xyqb.com:data-riskcontrol/urge_dispatcher.git"
		}
		_utils().beautyEcho("git_path:" + git_path, "info")
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
}

def checkout_nodejs(branchName, systemName) {
    git_path = project_attr(systemName)["gitPath"]
		currentPath = sh (
		    script: 'pwd',
		    returnStdout: true
		).trim()
    def folder = new File( "${currentPath}/.git/hooks" )
    if( !folder.exists() ) {
        git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
        
        def bowerFile = fileExists './bower.json'

        if (bowerFile) {
            sh "bower install --allow-root"
        }
        sh "npm install"
    }else{
        sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-merge .git/hooks/"
        sh "chmod +x .git/hooks/post-merge"
    
        git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
    }
}

def checkout_lua_ui(branchName, gitRepo) {
    if(gitRepo.contains("--")){
        t1 = gitRepo.split("/")
        groups = t1[0].split("--")
        projects = t1[1].split("--")
        branches = branchName.split("--")

        t1.size().times {

            dir (projects[it]) {
                project_attr = project_attr(projects[it])
                git_path = project_attr["gitPath"]
                
				currentPath = sh (
				    script: 'pwd',
				    returnStdout: true
				).trim()
                
                def folder = new File( "${currentPath}/.git/hooks" )
                if( !folder.exists() ) {
                    git branch: branches[it], credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
                    
                    def bowerFile = fileExists './bower.json'

                    if (bowerFile) {
                        sh "bower install --allow-root"
                    }
                    sh "npm install"
                }else{
                    sh "\\cp -rf /home/quant_group/config_repository/lua-ui/hook/post-merge .git/hooks/"
                    sh "chmod +x .git/hooks/post-merge"
                    git branch: branches[it], credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
                }
            }
        }
    }
    else{
        t1 = gitRepo.split("/")
        project = t1[1]
        
        dir (project) {
            project_attr = project_attr(project)
            git_path = project_attr["gitPath"]
            
			currentPath = sh (
			    script: 'pwd',
			    returnStdout: true
			).trim()
            
            def folder = new File( "${currentPath}/.git/hooks" )
            
            if( !folder.exists() ) {
                git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
                def bowerFile = fileExists './bower.json'

                if (bowerFile) {
                    sh "bower install --allow-root"
                }
                sh "npm install"
            }else{
                sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-merge .git/hooks/"
                sh "chmod +x .git/hooks/post-merge"
        
                git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: git_path
            }
        }
    }
}

def build_java(namespace, systemName, contextDir) {
    sh '/usr/share/maven/bin/mvn clean package -P test -D maven.test.skip=true'
}

def copy_files_java(systemName, contextDir) {
	    switch (systemName) {
	        case "baitiao-zhitou":
	            jar_path = "xyqb-btzt-internal/target/*.jar"
	            break
	        case "baitiao":
	            jar_path = "baitiao-api/target/*.jar"
	            break
            case "xyqb-display":
                jar_path = "display-api/target/*.jar"
                break
            case "zero-gateway-zuul":
                jar_path = "app-starter/target/*.jar"
                break
			case "baitiao-op-backend":
				jar_path = "xyqb-backend/target/*.jar"
                break
	        default:
	            jar_path = "target/*.jar"
	            break
	    } 
	    
	    sh "cp ${jar_path} ${contextDir}/"
}

def build_nodejs(namespace, systemName, contextDir) {    
    def res_json = project_attr(systemName)

    configPath = res_json["configPath"]
    buildCmd = res_json["buildCmd"]
    configName = systemName
        
    sh "mv -f env.config.js ${configPath}"
    sh 'tar zcf dist.tgz ./*'
    sh "mv dist.tgz ${contextDir}"
}

def build_python(namespace, systemName, contextDir) {
    sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
    sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"
    sh 'tar zcf dist.tgz server/'
    sh "mv dist.tgz ${contextDir}"
}

def build_luaui(namespace, systemNames, contextDir) {
    arrSystem = systemNames.split("--")
    for (systemName in arrSystem) {
        dir (systemName) {
            def res_json = project_attr(systemName)

            configPath = res_json["configPath"]
            buildCmd = res_json["buildCmd"]
            configName = systemName

            sh "mv -f ../${systemName}.env.config.js ${configPath}"
            
            sh buildCmd
            
            sh "tar zcf ${systemName}.tgz dist/"
            sh "mv ${systemName}.tgz ../${contextDir}"
        }
    }
}

def dockerbuild_and_push(timeNow, buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    
    k8sSystemName = systemName.replaceAll("_","-")
    safeBranchName = branchName.replaceAll(regex,"_")
    defaultSystemName = "project"
    
    imageTag = "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${buildNumber}"
   
    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_TIME=${timeNow} --build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${systemName} --build-arg BRANCH_NAME=${branchName} --build-arg SAFE_SYSTEM_NAME=${defaultSystemName} ${contextDir}")
            image.push()
            
            if (branchName == "master" || branchName == "master--master") {
                image.push('latest')
            }
                
        }
    }

    _utils().beautyEcho("镜像地址:${imageTag}", "info")
    return imageTag
}
    
def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    def deploy_job_info
    
    if (isDeploy=="true") {
        _utils().beautyEcho("[旧集群][deploy]将镜像更新到到Namespace:" + namespace, "info")
        deploy_job_info = build job: '3.deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "${tier}")]
        
        log = Jenkins.getInstance().getItemByFullName('3.deployer.Updater').getBuildByNumber(deploy_job_info.getNumber()).logFile.text
        return log
    }else{
        _utils().beautyEcho("namespace:[${namespace}]不存在，不执行deploy", "info")
    }
}

def deployV2(namespace, systemName, imageTag, tier, isDeploy) {
    def deploy_job_info
    
    if (isDeploy=="true") {
        _utils().beautyEcho("[新集群][deployV2]将镜像更新到到Namespace:" + namespace, "info")
		log = update_microservice(namespace, systemName, imageTag, tier)
		return log
    }else{
        _utils().beautyEcho("namespace:[${namespace}]不存在，不执行deploy", "info")
    }
}

def clean_images(imageTag) {
    sh "docker rmi -f \$(docker images -q ${imageTag})"
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}

def update_microservice(namespace, name, image, tier) {
	dest_url = "http://192.168.4.24/api/qahome/update_microservice"

	json_str = '{"namespace":' + namespace + ',"name":' + name + ',"image":'+ image +',"tier":' + tier + '}'
	echo json_str
	
	j = readJSON text:json_str

	response = httpRequest contentType: "APPLICATION_JSON", httpMode: "PUT", requestBody: JsonOutput.toJson(j), url: dest_url
    def res_json = jsonParse(response.content)
    return res_json
}



