


def call(body) {
	
	ansiColor('xterm') {
		
		def harborGroup = "library"
		def _stage = new org.qg.docker_new.StageBucket()
		def _utils = new org.qg.docker_new.Utils()
	   
		def config = [:]
		def timeStemp = new Date().format("yyyyMMddHHmmss")

		def env = body.env	    
		def gitRepo = env.GIT_REPO
		def originBranchName = env.BRANCH_NAME
		def namespace = env.NAMESPACE
		def isDeploy = env.IS_DEPLOY
		def buildNumber = env.BUILD_NUMBER
		def cluster = env.CLUSTER

		// QG/XXX or QG--QG/systemName--systemName
		t = gitRepo.split("/")
		def gitGroup = t[0]
		// systemName or systemName--systemName
		def originSystemName = t[1]	    
		// ["",""]
		def systemNames = originSystemName.split("--")
		def branchNames = originBranchName.split("--")

		def contextDir
		def imageTagInfos
		def branchHashCode     
		
		body.resolveStrategy = Closure.DELEGATE_FIRST
		body.delegate = config
		body()

	    node {   
			
			try { 
				echo config.buildType
				/*  1 */
				stage('Init') {
					_utils.beautyEcho("Init", "stage")
					contextDir = _stage.contextMkdir("${originSystemName}-${timeStemp}")
					_stage.init_dependency()
					_stage.init_image_dependency(config.buildType,originSystemName,contextDir)
				}
					
				/*  2 */
				echo originSystemName
				
				
			  
				withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
					_utils.beautyEcho("checkout & build < ${originSystemName} : ${originBranchName} >", "stage")


				    for(def i = 0; i<systemNames.length; i++){
						dir(systemNames[i]){
							branchHashCode = _stage.check_and_build(config.buildType, systemNames[i], branchNames[i], contextDir)
		
						}
					}
					
					_utils.beautyEcho("build over", "info")	
				}
				
	
				/*  3 */
				withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
					_utils.beautyEcho("make docker image", "stage")		
					def _systemName = originSystemName.toLowerCase()
					def regex = "[`,./;\\[\\]&<>?:\"()|-]+"
				    def k8sSystemName = originSystemName.replaceAll("_","-")
				    def safeBranchName = originBranchName.replaceAll(regex,"_")
					imageTagInfos = _stage.imageTag(harborGroup,k8sSystemName,safeBranchName,branchHashCode)

					for	(imageTagInfo in imageTagInfos){
						_stage.dockerbuild_and_push(imageTagInfo,buildNumber,_systemName,originBranchName ,cluster,timeStemp,contextDir)																	
					}
															
					_stage.deploy(namespace, _systemName, imageTagInfos[0]["imageTag"], config.tier, isDeploy)
				}
	
				/*  4 */
				stage('Clean'){
					_utils.beautyEcho("Clear Cache Tmp", "stage")											
					_stage.clean_images(imageTagInfos[0]["imageTag"],contextDir)																		
				}
								 				
			} catch (err) {
				_utils.beautyEcho(err, "fail")
				_stage.clean_images(imageTagInfos[0]["imageTag"],contextDir)					
				throw err			
			}
	    }
		
	}
}




