import org.qg.*

def call(body) {
    
    def config = [:]
    
    def _stage = new org.qg.StageBucket(body)
    def _utils = new org.qg.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        try {
            stage('Checkout') {
                contextDir = _utils.contextDir(workspace)
                _stage.checkout(branchName, contextDir, gitRepo)
            }

            stage('Build') {
                _stage.build(namespace, systemName, contextDir)
            }

            stage('Docker Build And Push') {
                imageTag = _stage.docker_build_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
            }

            stage('Deploy') {
                _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
            }
        
            stage("Clean") {
                _stage.clean(contextDir)
            }
        } catch (err) {
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}