import org.qg.ansible.*

def call(body) {
    def config = [:]
    def env = body.env
    
    def envType = env.env
    def nameWithNamespace = env.name_with_namespace
    def tagName = env.tag_name
    def projectName = nameWithNamespace.split("/")[1]
    def action = env.action 
    def force = env.force
    def dataCenter = env.data_center
    def machines = env.hosts
    
    def _utils = new org.qg.ansible.Utils()
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()
    
    node {
        stage('Clean') {
            deleteDir()
        }
        
        stage('Build') {
/*            sh "ansible-playbook /etc/ansible/build.yml -e project_name=${envType}.${projectName} -e name_with_namespace=${nameWithNamespace} -e tag_name=${tagName} -e force=${force} -vv"
*/       }

        stage('Deploy') {
            
            if (action == 'deploy') {
                echo 'deploy'
                arr_machines = machines.split(",")
                count = arr_machines.size()
                int_count = (count / 2).toInteger()
                machines_list = _utils.partList(arr_machines.toList(), int_count, count)
            
                for (machine in machines_list) {
                    echo "Is deploy to :" + machine
                    sh "ansible-playbook /etc/ansible/service.yml -e project_name=${envType}.${projectName} -e data_center=${dataCenter} -e machines=${machine[0]} -e force=${force} -vv"
                
                    env.RELEASE_ACTION = input '是否继续部署?'
                    sh "ansible-playbook /etc/ansible/${action}.yml -e project_name=${envType}.${projectName}  -e data_center=${dataCenter} -e machines=${machine[0]} -e force=${force} -vv"
                }
            }

            if (action == 'rollback') {
                echo 'rollback'
            }
            
        }
        
    }
}
