import org.qg.docker.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def originSystemName = t[1]
    def systemName = originSystemName.toLowerCase()

    def harborGroup = "library"
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def contextDir
    def _stage = new org.qg.docker.StageBucket()
    def _utils = new org.qg.docker.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {        
        try {
            dir (systemName) {
                timestamps {
                    stage('Clean') {
                        _utils.beautyEcho(1, 'Clean')
                    }
        
                    stage('Checkout') {
                        _utils.beautyEcho(2, 'Checkout')
                        switch (config.buildType) {
                            case "lua-ui":
                                _stage.checkout_lua_ui(branchName, gitRepo)
                                break
                            default:
                                _stage.checkout(branchName, systemName)
                                break
                        }
                    }
        
                    stage('Prepare') {
                        _utils.beautyEcho(3, 'Prepare')
                        contextDir = _utils.contextDir(workspace)
                        _stage.before_prepare(contextDir)
                        switch (config.buildType) {
                            case "java":
                                _stage.prepare_java(systemName, contextDir)
                                break
                            case "nodejs":
                                _stage.prepare_nodejs(systemName, contextDir)
                                break
                            case "python":
                                _stage.prepare_python(contextDir)
                                break
                            case "lua-ui":
                                _stage.prepare_luaui(systemName, contextDir)
                                break
                            default:
                                echo "未知的buildType: ${config.buildType}"
                                break
                        }
                    }
        
                    stage('Build') {8
                        ansiColor('xterm') {
                            echo -e '\033[35mPurple!\033[0m'
                            _utils.beautyEcho(4, 'Build')             
                            switch (config.buildType) {
                                case "java":
                                    _stage.build_java(namespace, originSystemName, contextDir)
                                    break                  
                                case  "nodejs":
                                    _stage.build_nodejs(namespace, originSystemName, contextDir)
                                    break
                                case "python":
                                    _stage.build_python(namespace, originSystemName, contextDir)
                                    break
                                case "lua-ui":
                                    _stage.build_luaui(namespace, originSystemName, contextDir)
                                    break                                
                                default:
                                    echo "未知的buildType: ${config.buildType}"
                                    break
                            }
                        }
                    }

                    stage('Docker Build And Push') {
                        _utils.beautyEcho(5, 'Docker Build And Push')   
                        if (config.buildType == "java") {
        		            _stage.copy_files_java(systemName, contextDir)
        		        }
                        imageTag = _stage.dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
                    }

                    stage('Deploy') {
                        def deploy_log
                        _utils.beautyEcho(6, 'Docker Build And Push')  
                        deploy_log = _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
                        echo deploy_log
                    }
        
                    stage("Clean") {
                        _utils.beautyEcho(7, 'Clean')  
                        _stage.clean_images(imageTag)
                    }
                }
            }
            
        } catch (err) {
            if (imageTag) {
                _stage.clean_images(imageTag)
            }
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}