import org.qg.docker.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def originSystemName = t[1]
    def systemName = originSystemName.toLowerCase()

    def harborGroup = "library"
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def contextDir
    def _stage = new org.qg.docker.StageBucket()
    def _utils = new org.qg.docker.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {        
        try {
            ansiColor('xterm') {
                dir (systemName) {
                    timestamps {
                        stage('Init') {
                            _utils.beautyEcho("Init", "stage")
                        }
        
                        stage('Checkout') {
                            _utils.beautyEcho("Checkout", "stage")
                            _utils.beautyEcho("systemName:[${systemName}];branchName:[${branchName}]", "info")
                            switch (config.buildType) {
                                case "lua-ui":
                                    _stage.checkout_lua_ui(branchName, gitRepo)
                                    break
                                case "nodejs":
                                    _stage.checkout_nodejs(branchName, gitRepo)
                                    break
                                default:
                                    _stage.checkout(branchName, systemName)
                                    break
                            }
                        }
        
                        stage('Prepare') {
                            _utils.beautyEcho("Prepare", "stage")
                            contextDir = _utils.contextDir(workspace)
                            _stage.before_prepare(contextDir)
                            switch (config.buildType) {
                                case "java":
                                    _stage.prepare_java(systemName, contextDir)
                                    break
                                case "nodejs":
                                    _stage.prepare_nodejs(systemName, contextDir)
                                    break
                                case "python":
                                    _stage.prepare_python(contextDir)
                                    break
                                case "lua-ui":
                                    _stage.prepare_luaui(systemName, contextDir)
                                    break
                                default:
                                    echo "未知的buildType: ${config.buildType}"
                                    break
                            }
                        }
        
                        stage('Build') {
                            _utils.beautyEcho("Build", "stage")
                            switch (config.buildType) {
                                case "java":
                                    _stage.build_java(namespace, originSystemName, contextDir)
                                    break                  
                                case  "nodejs":
                                    _stage.build_nodejs(namespace, originSystemName, contextDir)
                                    break
                                case "python":
                                    _stage.build_python(namespace, originSystemName, contextDir)
                                    break
                                case "lua-ui":
                                    _stage.build_luaui(namespace, originSystemName, contextDir)
                                    break                                
                                default:
                                    echo "未知的buildType: ${config.buildType}"
                                    break
                            }
                        }

                        stage('Docker Build And Push') {
                            _utils.beautyEcho("Docker Build And Push", "stage")
                            if (config.buildType == "java") {
            		            _stage.copy_files_java(systemName, contextDir)
            		        }
                            imageTag = _stage.dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
                        }

                        stage('Deploy To K8s Cluster') {
                            _utils.beautyEcho("Deploy To K8s Cluster", "stage")
                            def deploy_log = _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
                            _utils.beautyEcho(deploy_log, "info")
                        }
        
/*                        stage("Clean") {
                            _utils.beautyEcho("Clean", "stage")
                            _stage.clean_images(imageTag)
                        }*/
                    }
                }
            }   
        } catch (err) {
            ansiColor('xterm') {
/*                if (imageTag) {
                    _stage.clean_images(imageTag)
                }*/
                currentBuild.result = 'FAILED'
                _utils.beautyEcho(err, "fail")
                throw err
            }
        }
    }
}