// src/org/foo/Stage.groovy
package org.qg;
import groovy.json.JsonSlurperClassic;
import org.qg.Utils;

def prepare_java(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/java; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/java ${contextDir}"
    
    sh "cd /home/quant_group/config_repository/java; git pull; cd -"
    sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}/application.properties"
    sh "sed -i \"s/.xyqb.com/-${namespace}.q-gp.com/\" ${contextDir}/application.properties"
}

def prepare_nodejs(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/nodejs; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/nodejs ${contextDir}"
    
    sh "cd /home/quant_group/config_repository/java; git pull; cd -"
    sh "cp -rf /home/quant_group/config_repository/nodejs/${systemName}.js env.config.js"
    sh "sed -i \"s/.xyqb.com/-${namespace}.q-gp.com/\" env.config.js"
}

def prepare_ui(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/ui; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/ui ${contextDir}"
    
    sh "cd /home/quant_group/config_repository/java; git pull; cd -"
    sh "cp -rf /home/quant_group/config_repository/ui/${systemName}.js env.config.js"
    sh "sed -i \"s/.xyqb.com/-${namespace}.q-gp.com/\" env.config.js"
}

def prepare_python(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/python; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
}

def checkout(branchName, gitRepo) {
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@git.quantgroup.cn:${gitRepo}.git"
}

def build_java(namespace, systemName, contextDir) {
    sh '/usr/share/maven/bin/mvn clean package -P test -D maven.test.skip=true'
}

def copy_files_java(systemName, contextDir) {
	    switch (systemName) {
	        case "baitiao-zhitou":
	            jar_path = "xyqb-btzt-internal/target/*.jar"
	            break
	        case "baitiao":
	            jar_path = "baitiao-api/target/*.jar"
	            break
	        default:
	            jar_path = "target/*.jar"
	            break
	    } 
	    
	    sh "cp ${jar_path} ${contextDir}/"
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def build_ui(namespace, systemName, contextDir, repoName, branchName, workspace) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_node_command/${systemName}"

    def res_json = jsonParse(response.content)
    print "=====Build Command Is====="
    echo res_json.toString()
    configPath = res_json["configPath"]
    buildCmd = res_json["buildCmd"]
    configName = systemName
    print "=========================="

/*    sh "cp -rf /home/quant_group/jenkins_home/workspace/pre.${systemName}/node_modules/ node_modules"*/
    sh "mv -f env.config.js ${configPath}"

    def bowerFile = fileExists './bower.json'
    
    if (bowerFile) {
        sh "bower install"
    }
    
    sh buildCmd
    sh 'tar zcf dist.tgz dist/'
    sh "mv dist.tgz ${contextDir}"
}

def build_nodejs(namespace, systemName, contextDir, repoName, branchName, workspace) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_node_command/${systemName}"
    
    def res_json = jsonParse(response.content)
    print "=====Build Command Is====="
    echo res_json.toString()
    configPath = res_json["configPath"]
    buildCmd = res_json["buildCmd"]
    configName = systemName
    print "=========================="
    def bowerFile = fileExists './bower.json'
    
    if (bowerFile) {
        sh "bower install"
    }
    
/*    sh "cp -rf /home/quant_group/jenkins_home/workspace/pre.${systemName}/node_modules/ node_modules"
*/    
    sh "mv -f env.config.js ${configPath}"

    sh "npm install --registry=https://registry.npm.taobao.org"
    sh 'tar zcf dist.tgz ./*'
    sh "mv dist.tgz ${contextDir}"
}

def build_python(namespace, systemName, contextDir) {
    sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
    sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"
    sh 'tar zcf dist.tgz server/'
    sh "mv dist.tgz ${contextDir}"
}

def dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${safeSystemName} ${contextDir}")
            image.push()
            image.push('latest')
        }
    }

    echo "=================镜像地址================="
    echo imageTag
    echo "========================================="
    
    return imageTag
}
    
def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    if (isDeploy=="true") {
        echo ("将镜像更新到到Namespace:" + namespace)
        build job: 'deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "${tier}")]
    }else{
        echo "namespace不存在，不执行deploy"
        echo namespace
    }
}

def clean_images(imageTag) {
    sh "docker rmi -f \$(docker images -q ${imageTag})"
}

def clean_dir(contextDir) {
    deleteDir()
}