import org.qg.ansible.*

def call(body) {
    
    def config = [:]
    def env = body.env
    
    def envType = env.env
    def nameWithNamespace = env.name_with_namespace
    def tagName = env.tag_name
    def projectName = nameWithNamespace.split("/")[1]
    def action = env.action
    def dataCenter = env.data_center
    def machines = env.hosts
    
    
    def _utils = new org.qg.ansible.Utils()
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()
    
    node {
        stage('Clean') {
            deleteDir()
        }
        
        stage('Build') {
            echo projectName
            
/*            sh "ansible-playbook /etc/ansible/build.yml -e project_name=${envType}.${projectName} -e name_with_namespace=${nameWithNamespace} -e tag_name=${tagName} -vv"*/
        }

        stage('Deploy') {
            arr_machines = machines.split(",")
            count = arr_machines.size()
            int_count = (count / 2).toInteger()
            machines_list = _utils.partList(arr_machines, int_count)
            print machines_list
            
            for (machine in machines_list) {
                sh "ansible-playbook /etc/ansible/nginx_remove.yml -e project_name=${envType}.${projectName} -e data_center=${dataCenter} -e machines=${machine} -vv"
            
            
                env.RELEASE_ACTION = input message: '请选择下一步部署动作', ok: '确认',
                        parameters: [choice(name: 'RELEASE_SCOPE', choices: 'Deploy\nRollback', description: '请谨慎选择你要进行的操作')]
                    
                if (env.RELEASE_ACTION == "Deploy") {
                    sh "ansible-playbook /etc/ansible/${action}.yml -e project_name=${envType}.${projectName}  -e data_center=${dataCenter} machines=${machine} -vv"
                }else{
                    sh "ansible-playbook /etc/ansible/nginx_add.yml -e project_name=${envType}.${projectName} -e  data_center=${dataCenter} machines=${machine} -vv"
                }
            }
            
        }
    }
}
