import org.qg.ansible.*

def call(body) {
    def config = [:]
    def env = body.env
    def envType = env.env
    def nameWithNamespace = env.name_with_namespace
    def tagName = env.tag_name
    def tingyun = env.tingyun
    def projectName = nameWithNamespace.split("/")[1]
    def action = env.action 
    def force = env.force
    def dataCenter = env.data_center
    def machines = env.hosts
    def operation = env.operation
    
    def _utils = new org.qg.ansible.Utils()
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()
     
    node {
        stage('Clean') {
            deleteDir()
        }
				def deployUser 
        wrap([$class: 'BuildUser']) {
            deployUser = BUILD_USER
        }
	if (dataCenter == "A" || dataCenter == "C" || dataCenter == "PRE") {
		if ( operation == "online" || operation == "offline") {
			sh "ansible-playbook /etc/ansible/online-offline.yml -e project_name=${projectName} -e data_center=${dataCenter} -e machines=${machines} -e env=${envType} -e operation=${operation} -v"
		}else{
			stage('Build') {
                        	if (action == 'deploy') {
                                	sh "ansible-playbook /etc/ansible/build.yml -e project_name=${projectName} -e data_center=${dataCenter} -e name_with_namespace=${nameWithNamespace} -e tag_name=${tagName} -e force=${force} -e env=${envType} -v"
                        	}
                	}

                	stage('Deploy') {
                        	if (action == 'deploy') {
                                	sh "ansible-playbook /etc/ansible/${action}-test.yml -e project_name=${projectName}  -e data_center=${dataCenter} -e machines=${machines} -e tag_name=${tagName} -e force=${force} -e env=${envType} -v"
                                           if (nameWithNamespace.startsWith("DevOps") || 
                                                     nameWithNamespace.startsWith("QG")  || 
                                                     nameWithNamespace.startsWith("head_group")  || 
                                                     nameWithNamespace.startsWith("funding")  || 
                                                     nameWithNamespace.startsWith("fund_pay") ) {
                                                  try {
                                                        sh "cd /home/quant_group/code/" +  projectName + ";" \
                                                                 + "tagMessage=\$(git tag -l -n99  " +  tagName+ ");" \
                                                                 + "curl -G --data-urlencode \"tagMessage=\$tagMessage\" http://sonar.quantgroups.com/cicd/jenkins_deploy?deployUser="+deployUser+"\\&tagName=" + tagName + "\\&projectName=" + projectName +";" 
                                                        }
                                                      catch (exc) {
                                                        echo '发送上线通知失败，建议尝试人工通知'
                                                      }
                                             }
                                          
                        	}

                        	if (action == 'rollback') {
                                	sh "ansible-playbook /etc/ansible/${action}.yml -e project_name=${projectName}  -e data_center=${dataCenter} -e machines=${machines} -e rollback_to_release=${tag_name} -e force=${force} -e env=${envType} -v"
                        	}
                	}
		}
	}else{
		sh "ansible-playbook /etc/ansible/k8s-deploy.yml -e project_name=${projectName} -e data_center=${dataCenter} -e env=${envType} -e image=${image} -v"
	}
    }
}
