
def call(body) {
    
    def config = [:]
    def env = body.env
    
    def repoName = env.repo_name
    t = repoName.split("/")
    def gitGroup = t[0]
    def projectName = t[1]
    
    def branchName = env.branch_name
    def room = env.room
    def hosts = env.hosts
    def action = env.action
    def rollbackToRelease = env.rollback_to_release
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        stage('Clean') {
            deleteDir()
        }
        
        stage('Build') {
            echo envType
            sh "ansible-playbook /etc/ansible/build.yml -e project_name=${config.envType}.${projectName} -e repo_name=${repoName} -e branch_name=${branchName}"
        }

        stage('Deploy') {
            echo "deploy"
        }
    }
}