def call(body) {
  def _stage = new org.qg.ci.SonarStageBucketTke()
  def _utils = new org.qg.docker_new.Utils()
  def env = body.env
  def GIT_REPO = env.GIT_REPO
  def BRANCH_NAME = env.BRANCH_NAME
  def FORCE_SCAN = env.FORCE_SCAN
  def GIT_TRIGGER_USER = env.GIT_TRIGGER_USER
  def config = [:]
  def data

  body.resolveStrategy = Closure.DELEGATE_FIRST
  body.delegate = config
  body()
  def callbackHost = config.callbackHost
  def dingRobotAddr = config.dingRobotAddr

  def schemaInfo = ""+
    "\033[32m############################################\n"+
    "#  GIT_REPO:${GIT_REPO}\n"+
    "#  BRANCH_NAME:${BRANCH_NAME}\n"+
    "#  FORCE_SCAN:${FORCE_SCAN}\n"+
    "#  GIT_TRIGGER_USER:${GIT_TRIGGER_USER}\n"+
    "#  COMMIT_MESSAGE:${COMMIT_MESSAGE}\n"+
    "#  CallbackHost:${callbackHost}\n"+
    "#  DingRobotAddr:${dingRobotAddr}\n"+
    "############################################\033[0m"
  ansiColor('xterm') {
    echo schemaInfo

    node {
      dir(GIT_REPO){
        try { 
          stage("Checkout"){
            _utils.beautyEcho("Checkout +++", "stage")
            _stage.checkout(GIT_REPO,BRANCH_NAME)
          }

          stage("Sonar scan"){
            _utils.beautyEcho("Sonar scan +++", "stage")
            data = _stage.sonar_check(GIT_REPO,BRANCH_NAME,FORCE_SCAN)
          }

          stage("Callback sonar analysis"){
            _utils.beautyEcho("Callback sonar analysis +++", "stage")
            _stage.call_back(data,callbackHost,dingRobotAddr)
          }
        } catch (err) {
          _stage.callback_error(err,callbackHost,,dingRobotAddr)
          throw err
        }
      }
    }
  }
}
