def call(body) {

  ansiColor('xterm') {

    def _stage = new org.qg.docker_new.StageBucketTke2()
    def _sonarStage = new org.qg.ci.SonarStageBucketTke()
    def _utils = new org.qg.docker_new.Utils()

    def config = [:]
    def timeStemp = new Date().format("yyyyMMddHHmmssSSS")
    def env = body.env
    def systemName = env.GIT_REPO
    def branchName = env.BRANCH_NAME
    def namespace = env.NAMESPACE
    def isDeploy = env.DEPLOY
    def buildNumber = env.BUILD_NUMBER
    def cluster = env.CLUSTER
    def contextDir
    def imageTagInfos
    def branchHashCode
    def imageTagInfo = [:]
    def sonarJob

    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    def sonarCallback = config.sonarCallback
    def pipesCallback = config.pipesCallback
    def dingRobotAddr = config.dingRobotAddr

    if(config.imageRepo != null){
      imageRepo = config.imageRepo
    }

    node {
      try {
        echo config.buildType
        /*  1 */
        stage('Init') {
          _utils.beautyEcho("Init", "stage")
          contextDir = _stage.contextMkdir("${systemName}-${timeStemp}")
          _stage.init_dependency()
          // _stage.init_image_dependency(config.buildType,systemName,contextDir)
        }

        /*  2 */
        echo systemName
        withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
          _utils.beautyEcho("checkout & build < ${systemName} : ${branchName} >", "stage")
          dir(systemName){
            branchHashCode = _stage.check_and_build(config.buildType, systemName, branchName, contextDir)
          }
          _utils.beautyEcho("build over", "info")
        }

        stage("Sonar Check"){
          _utils.beautyEcho("sonar check +++", "stage")
          dir(systemName){
           _stage.get_sonar_check(systemName,branchName,pipesCallback,sonarCallback,dingRobotAddr,branchHashCode)
          }
          _utils.beautyEcho("sonar check over", "info")
        }

        /*  3 */
        withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
          _utils.beautyEcho("make docker image", "stage")
          def regex = "[`,./;\\[\\]&<>?:\"()|-]+"
          def k8sSystemName = systemName.replaceAll("_","-").toLowerCase()
          def safeBranchName = branchName.replaceAll(regex,"_").toLowerCase()

          imageTagInfo = _stage.imageTag(imageRepo,k8sSystemName,safeBranchName,timeStemp)

          _stage.dockerbuild_and_push(imageTagInfo,buildNumber,systemName,branchName,timeStemp,contextDir)
          _stage.deploy(namespace, systemName, imageTagInfo["imageTag"], config.tier, isDeploy, cluster)
        }

        /*  4  */
        stage('Clean'){
          _utils.beautyEcho("Clear Cache Tmp", "stage")
          _stage.clean_images(imageTagInfo["imageTag"],contextDir)
          _stage.ding_talk_suc(pipesCallback,"success",dingRobotAddr,systemName,imageTagInfo["imageTag"],cluster,config.tier)
        }
      } catch (err) {
        _utils.beautyEcho(err, "fail")
        _stage.ding_talk_error(pipesCallback,"runError",dingRobotAddr,systemName,branchName,err.message,sonarJob)
        _stage.clean_images(imageTagInfo["imageTag"],contextDir)
        throw err
      }
    }
  }
}
