import org.qg.*

def call(body) {
    
    def config = [:]
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        branchName = body.env.BRANCH_NAME
        gitRepo = body.env.GIT_REPO
        namespace = body.env.NAMESPACE
        isDeploy = body.env.IS_DEPLOY
        buildNumber = body.env.BUILD_NUMBER
        
        try {
            stage ('Clone') {
                print branchName
            }
            stage ('Build') {
                sh "echo 'building ${config.projectName} ...'"
            }
            stage ('Tests') {
                parallel 'static': {
                    sh "echo 'shell scripts to run static tests...'"
                },
                'unit': {
                    sh "echo 'shell scripts to run unit tests...'"
                },
                'integration': {
                    sh "echo 'shell scripts to run integration tests...'"
                }
            }
            stage ('Deploy') {
                sh "echo 'deploying to server ${config.serverDomain}...'"
            }
        } catch (err) {
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}