// src/org/foo/Stage.groovy
package org.qg;

def checkout(branchName, contextDir, gitRepo) {
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/ui ${contextDir}"
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@gitabc.xyqb.com:${gitRepo}.git"
    sh "git pull origin master"
}

def build(namespace, systemName, contextDir, buildType) {
    switch (buildType) {
        case "java":
            env.PATH = "${tool 'M3'}/bin:${env.PATH}"
            sh 'mvn clean package -P test -D maven.test.skip=true'
            break
        case "ui" || "nodejs":
            sh "ansible-playbook /etc/ansible/build.yml -e prefix=${namespace} -e project_name=pre.${systemName} -e workspace=${contextDir} -vv"
            break
        case "python":
            sh "mv ${contextDir}/config.ini config.ini"
            sh "cp -f config.ini server/config/release/config.ini"   
            sh "cp -f config.ini ${configPath}"
            sh 'tar zcf dist.tgz server/'
            break
        default:
            break
    } 
}

def docker_build_and_push(buildNumber, branchName, harborGroup, systemName, contextDir) {
    /*分支名中非法字符统一替换为下划线*/
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${safeSystemName} ${contextDir}")
            image.push()
        }
    }

    echo "=================镜像地址================="
    echo imageTag
    echo "========================================="
    
    return imageTag
}

def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    if (isDeploy) {
        echo ("将镜像更新到到Namespace:" + namespace)
        build job: 'deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "${tier}")]
    }else{
        echo "namespace不存在，不执行deploy"
        echo namespace
    }
}

def clean(contextDir) {
    sh "rm -rf ./${contextDir}"
}




