import org.qg.docker.*
import java.time.*

def getTime(){
	LocalDateTime t = LocalDateTime.now();
	return t as String
}

def call(body) {
	
	  
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER
		def cluster = env.CLUSTER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def originSystemName = t[1]
    def systemName = originSystemName.toLowerCase()

    echo "====JOB_NAME : ${env.JOB_NAME}"
		
		def harborGroup = "library"
/*		def workspace = "/home/quant_ group/jenkins_home/workspace/${env.JOB_NAME}"*/
    
    def imageTag
		def timeStemp = new Date().format("yyyyMMddHHmmss")
    def _stage = new org.qg.docker.StageBucket()
    def _utils = new org.qg.docker.Utils()
    def contextDir = "/home/quant_group/package/${systemName}-${timeStemp}"
		
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {   
			  
			try { 
				sh "mkdir -p ${contextDir}"
				
				withDockerServer([uri: "tcp://172.29.1.15:2375/"]) {
					
					def volume = "-v /root/.m2:/root/.m2 "
					volume +="-v /home/quant_group/qg-dockerfiles:/home/quant_group/qg-dockerfiles "
					volume +="-v /home/quant_group/config_repository:/home/quant_group/config_repository "
					volume +="-v /home/quant_group/package/:/home/quant_group/package/ "
					
					docker.image("192.168.4.36/baseimg/jenkins-slave:2018040302").inside(volume){
						git_path = project_attr(systemName)["gitPath"]
						if(git_path =="git@gitabc.xyqb.com:data-riskcontrol/urge-dispatcher.git"){
							git_path = "git@gitabc.xyqb.com:data-riskcontrol/urge_dispatcher.git"
						}							

						git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: git_path


						sh 'mvn clean package -P test -D maven.test.skip=true'
						applicaton_properties = "/home/quant_group/config_repository/java/${systemName}.properties"
						
						echo applicaton_properties
						
						sh "if [ -f ${applicaton_properties} ]; then cp -rf ${applicaton_properties} ${contextDir}/application.properties; else echo \"## useing apollo ##\" > ${contextDir}/application.properties; fi"
						
						sh "cp -rf /home/quant_group/qg-dockerfiles/templates_new/java/* ${contextDir}"
						
						sh "cp target/*.jar ${contextDir}/app.jar"
					
					}
					
					
			    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
					
			    k8sSystemName = systemName.replaceAll("_","-")
			    safeBranchName = branchName.replaceAll(regex,"_")
			    defaultSystemName = "project"	
					timeStemp = new Date().format("yyyyMMddHHmmss")

			    imageTag = "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${timeStemp}"
					
			    withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
						
						def build_schema = "BUILD_TIME: ${timeStemp} ,BUILD_NUMBER: ${buildNumber},SYSTEM_NAME: ${systemName},BRANCH_NAME: ${branchName}, CLUSTER: ${cluster}"
						
						def image = docker.build(imageTag, "--build-arg BUILD_SHCEMA=build_schema ${contextDir}")
			        image.push()
        
			        if (branchName == "master" || branchName == "master--master") {
			            image.push('latest')
			        }
            
			    }
					
					
				}	
				
		   				
			}catch (err) {

            ansiColor('xterm') {

                currentBuild.result = 'FAILED'
                /*_utils.beautyEcho(err, "fail")*/
                throw err
            }
        }finlly(){
					sh "rm -rf ${contextDir}"
					_stage.clean_images(imageTag)
				}
    }
}


@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://172.29.1.15:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}