


def call(body) {
	
	ansiColor('xterm') {
		
			def harborGroup = "library"
			def _stage = new org.qg.docker_new.StageBucket()
			def _utils = new org.qg.docker_new.Utils()
	   
	    def config = [:]
	    def timeStemp = new Date().format("yyyyMMddHHmmss")
		
	    def env = body.env
	    def branchName = env.BRANCH_NAME
	    def gitRepo = env.GIT_REPO
	    def namespace = env.NAMESPACE
	    def isDeploy = env.IS_DEPLOY
	    def buildNumber = env.BUILD_NUMBER
			def cluster = env.CLUSTER
    
			t = gitRepo.split("/")
	    def gitGroup = t[0]
	    def systemName = t[1].toLowerCase()
    	
			def contextDir
	    def imageTag  
		
	    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
		
	    k8sSystemName = systemName.replaceAll("_","-")
	    safeBranchName = branchName.replaceAll(regex,"_")
		
	    body.resolveStrategy = Closure.DELEGATE_FIRST
	    body.delegate = config
	    body()

	    node {   
			  
				try { 
					echo config.buildType
					stage('prepare') {
						_utils.beautyEcho("Prepare", "stage")
						contextDir = _stage.contextMkdir("${systemName}-${timeStemp}")
						_stage.before_prepare()
					}
									
					
				
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
					
						stage('checkout & build') {
							_utils.beautyEcho("checkout & build", "stage")
						  
					    arrSystem = systemName.split("--")
					    for (systemNameSimple in arrSystem) {
								_stage.checkAndBuild(config.buildType, systemNameSimple, branchName, contextDir)
							}
							
						}
					}
					
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
						_utils.beautyEcho("build over", "info")				
						stage('make docker image') {
							_utils.beautyEcho("make docker image", "stage")			
							_stage.dockerMake(buildNumber,systemName,branchName,cluster,harborGroup,k8sSystemName,safeBranchName,timeStemp)
								
						}	
							
						stage('Deploy To K8s Cluster'){
							_utils.beautyEcho("Deploy To K8s Cluster", "stage")		
							 
							_stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)

							
														
						}
						
						
					}
								 				
				}catch (err) {
				
					_utils.beautyEcho(err, "fail")
					sh "rm -rf ${contextDir}"
					if (imageTag){
						_stage.clean_images(imageTag)
					}
					
					throw err
					
				
	      }
	    }
		}
}




