// src/libs/utils.groovy
package libs;
import libs.utils;

def debug() {
    print "123"
}

def checkout(contextDir, gitRepo) {
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/ui ${contextDir}"
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@gitabc.xyqb.com:${gitRepo}.git"
    sh "git pull origin master"
}

def build(namespace, systemName, contextDir) {
    sh "ansible-playbook /etc/ansible/build.yml -e prefix=${namespace} -e project_name=pre.${systemName} -e workspace=${contextDir} -vv"
}

def docker_build_and_push(buildNumber, branchName, contextDir) {
    /*分支名中非法字符统一替换为下划线*/
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${safeSystemName} ${contextDir}")
            image.push()
        }
    }

    echo "=================镜像地址================="
    echo imageTag
    echo "========================================="
    
    return imageTag
}

def deploy(namespace, systemName, imageTag, isDeploy) {
    if (isDeploy) {
        echo ("将镜像更新到到Namespace:" + namespace)
        build job: 'deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "backend")]
    }else{
        echo "namespace不存在，不执行deploy"
        echo namespace
    }
}

def clean(contextDir) {
    sh "rm -rf ./${contextDir}"
}




